<?php
	
	if(!defined('WS_ROOT_FILE')) { 
		header('HTTP/1.0 403 Forbidden');
		exit;
	}
	
	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Get slider key
	$key = $sliderid = (int) $_GET['id'];

	// Get slider
	$slider = $sliders[$key];

	// var_dump($slider);

	$defaults = array(

		// Layout
		'width' => 600,
		'height' => 300,
		'responsive' => true,

		// Weather & Time settings
		'measurement' => 'metric',
		'timeformat' => 12,
		'daytime' => '7,19',
		'windyweather' => 18,
		'icytemp' => -2,

		// Slideshow
		'slidedelay' => 0,
		'refreshinterval' => 0,
		'keybnav' => true,
		'touchnav' => true,

		// Appearance
		'background' => false,
		'searchfileld' => true,
		'alwaysshowsearchfileld' => false,
		'weatherinfo' => true,
		'forecast' => true,
		'alwaysshowforecast' => false,
		'cssanimations' => true,
		'jsanimations' => true,
		'infoduration' => 450,
		'infoboxeasingin' => 'easeOutBack',
		'infoboxeasingout' => 'easeInBack',
		'reduction' => 'auto',

		// Contents of the infobox
		'showlocation' => true,
		'showtime' => true,
		'showconditions' => true,
		'showtemperature' => true,
		'showlowtemp' => true,
		'showhightemp' => true,
		'showhumidity' => true,
		'showprec' => true,
		'showwind' => true,
		'showpress' => true,
		'showvisibility' => true,
		'showfday' => true,
		'showfcondition' => true,
		'showflow' => true,
		'showfhigh' => true,

		// Animattion settings
		'snow' => true,
		'rain' => true,
		'wind' => true,
		'lightnings' => true,
		'winddirection' => true
	);

	$isNew = isset($slider['edited']) ? false : true;

	if(empty($slider['infoboxeasingin'])) {
		$slider['infoboxeasingin'] = 'easeOutBack';
	}

	if(empty($slider['infoboxeasingout'])) {
		$slider['infoboxeasingout'] = 'easeInBack';
	}
?>
<div class="wrap">
	<h2>
		<?php _e('Editing slider: ', WS_TEXTDOMAIN) ?>
		<?php echo !empty($slider['title']) ? $slider['title'] : 'Unnamed'  ?>
		<a href="?page=weatherslider" class="add-new-h2"><?php _e('Back to the list', WS_TEXTDOMAIN) ?></a>
	</h2>

	<form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post">
		<?php wp_nonce_field('ws-edit-slider'); ?>
		<input type="hidden" name="ws_posted_edit" value="1">
		<input type="hidden" name="sliderkey" value="<?php echo $key ?>">
		<input type="hidden" name="slider_data[edited]" value="1">
		<input type="hidden" name="slider_data[date_c]" value="<?php echo !empty($slider['date_c']) ? $slider['date_c'] : '' ?>">
		<input type="hidden" name="slider_data[date_m]" value="<?php echo time() ?>">
		
		<!-- Slider title -->
		<div class="ws-slider-titlewrap">
			<input type="text" name="slider_data[title]" value="<?php echo $slider['title'] ?>" id="title" autocomplete="off" placeholder="<?php _e('Type your slider name here', WS_TEXTDOMAIN) ?>">
			<div class="ws-slider-slug">
				Slider slug:<input type="text" name="slider_data[slug]" value="<?php echo !empty($slider['slug']) ? $slider['slug'] : '' ?>" autocomplete="off" placeholder="<?php _e('e.g. homepageslider', WS_TEXTDOMAIN) ?>" data-help="Set a custom slider identifier to use in shortcodes instead of the database ID. Needs to be unique, and can contain only alphanumeric characters. This setting is optional.">
			</div>
		</div>

		<div class="ws-box ws-settings">
			<h3 class="header medium"><?php _e('Slider settings', WS_TEXTDOMAIN) ?></h3>
			<table>

				<thead>
					<tr>
						<td colspan="3">
							<span class="dashicons dashicons-editor-distractionfree"></span>
							<h4><?php _e('Layout', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Width', WS_TEXTDOMAIN) ?></td>
						<td><input type="number" min="240" max="1300" name="slider_data[width]" value="<?php echo !empty($slider['width']) ? $slider['width'] : '600' ?>"></td>
						<td class="desc"><?php _e('The slider width between 240-1300 pixels.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Height', WS_TEXTDOMAIN) ?></td>
						<td><input type="number" min="200" max="600" name="slider_data[height]" value="<?php echo !empty($slider['height']) ? $slider['height'] : '300' ?>"></td>
						<td class="desc"><?php _e('The slider height between 200-600 pixel.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Responsive', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[responsive]" <?php echo (($isNew && $defaults['responsive']) || isset($slider['responsive'])) ? ' checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Responsive mode provides optimal viewing experience across a wide range of devices (from desktop to mobile) by adapting and scaling your sliders for the viewing environment.', WS_TEXTDOMAIN) ?></td>
					</tr>
				</tbody>
				<thead>
					<tr>
						<td colspan="3">
							<span class="dashicons dashicons-location"></span>
							<h4><?php _e('Locations', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Location', WS_TEXTDOMAIN) ?></td>
						<td>
							<div class="ws-location-wrapper">
								<input type="text" name="location" id="ws-location-input" placeholder="Sydney, Australia">
								<ul id="ws-location-autocomplete"></ul>
							</div>
						</td>
						<td class="desc"><button class="button" id="ws-location-add"><?php _e('Add location', WS_TEXTDOMAIN) ?></button></td>
					</tr>
					<tr>
						<td colspan="3">
							<ul id="ws-location-list">
								<?php if(!empty($slider['locations']) && is_array($slider['locations'])) { ?>
								<?php foreach($slider['locations'] as $key => $val) : ?>
								<?php $title = isset($slider['titles'][$key]) ? stripslashes($slider['titles'][$key]) : '' ?>
								<li>
									<span class="ws-icon-move dashicons dashicons-editor-justify"></span>
									<input type="text" name="slider_data[locations][]" value="<?php echo $val ?>">
									<input type="text" class="ws-editor-location-title" name="slider_data[titles][]" placeholder="<?php _e('Custom location name', WS_TEXTDOMAIN) ?>" value="<?php echo $title ?>">
									<span class="ws-icon-remove dashicons dashicons-dismiss"></span>
									<div class="clear"></div>
								<?php endforeach; ?>
								<?php } else { ?>
								<li class="ws-location-notice"><?php _e("You didn't add any location to this slider yet!", WS_TEXTDOMAIN) ?></li>
								<?php } ?>
							</ul>
						</td>
					</tr>
				</tbody>
				<thead>
					<tr>
						<td colspan="3">
							<span class="dashicons dashicons-admin-tools"></span>
							<h4><?php _e('Weather & Time settings', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Measurement', WS_TEXTDOMAIN) ?></td>
						<td>
							<select name="slider_data[measurement]">
								<option value="metric" <?php echo (!empty($slider['measurement']) && $slider['measurement'] == 'metric') ? 'selected="selected"' : '' ?>><?php _e('Metric', WS_TEXTDOMAIN) ?></option>
								<option value="imperial" <?php echo (!empty($slider['measurement']) && $slider['measurement'] == 'imperial') ? 'selected="selected"' : '' ?>><?php _e('Imperial', WS_TEXTDOMAIN) ?></option>
							</select>
						</td>
						<td class="desc"><?php _e('Your preferred unit of the measurement.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Time Format', WS_TEXTDOMAIN) ?></td>
						<td>
							<select name="slider_data[timeformat]">
								<option value="12" <?php echo (!empty($slider['timeformat']) && $slider['timeformat'] == '12') ? 'selected="selected"' : '' ?>><?php _e('12 hour clock', WS_TEXTDOMAIN) ?></option>
								<option value="24" <?php echo (!empty($slider['timeformat']) && $slider['timeformat'] == '24') ? 'selected="selected"' : '' ?>><?php _e('24 hour clock', WS_TEXTDOMAIN) ?></option>
							</select>
						</td>
						<td class="desc"><?php _e('You can switch between 12 and 24-hour clock format.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Daytime', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[daytime]" value="<?php echo !empty($slider['daytime']) ? $slider['daytime'] : '7,19' ?>"></td>
						<td class="desc"><?php _e('The script tries automatically determine day/night cycles. If fails, it will revert back to the specified hours you can specify separating with a comma.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Windy Weather', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[windyweather]" value="<?php echo !empty($slider['windyweather']) ? $slider['windyweather'] : '18' ?>"></td>
						<td class="desc"><?php _e("WeatherSlider will use a special animation if the current wind speed goes beyond than the one you've specified in kmph.", WS_TEXTDOMAIN) ?></td>
					</tr>

					<tr>
						<td><?php _e('Icy Temperature', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[icytemp]" value="<?php echo !empty($slider['icytemp']) ? $slider['icytemp'] : '-2' ?>"></td>
						<td class="desc"><?php _e("WeatherSlider will show an icy layer in the widget if the current temperature is lower than the value you've specified in Celsius.", WS_TEXTDOMAIN) ?></td>
					</tr>

				</tbody>
				<thead>
					<tr>
						<td colspan="3">
							 <span class="dashicons dashicons-editor-video"></span>
							 <h4><?php _e('SlideShow', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Slide delay', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[slidedelay]" value="<?php echo !empty($slider['slidedelay']) ? $slider['slidedelay'] : '0' ?>"></td>
						<td class="desc"><?php _e('Enter a value greater than zero to enable automatic location switching in the widget. This value is in milliseconds, so the value 5000 means that WeatherSlider will wait 5 seconds before swapping to the next location in the slider.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Refresh interval', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[refreshinterval]" value="<?php echo !empty($slider['refreshinterval']) ? $slider['refreshinterval'] : '0' ?>"></td>
						<td class="desc"><?php _e('Enter a value greater than zero to enable periodically updating the weather informations in the widget. This value is in milliseconds, so the value 300 000 will update the weather info in every 5 minutes.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Keyboard navigation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[keybnav]" <?php echo (($isNew && $defaults['keybnav']) || isset($slider['keybnav'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('You can navigate through your locations in the widget by using the left and right arrow keys on your keyboard.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Touch navigation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[touchnav]" <?php echo (($isNew && $defaults['touchnav']) || isset($slider['touchnav'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Enables the swipe gesture on mobile devices to navigate between locations in the widget.', WS_TEXTDOMAIN) ?></td>
					</tr>
				</tbody>
				<thead>
					<tr>
						<td colspan="3">
							<span class="dashicons dashicons-admin-appearance"></span>
							<h4><?php _e('Appearance', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Hide background', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[background]" <?php echo (($isNew && $defaults['background']) || isset($slider['background'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('You can show / hide the background of the widget.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Enable search field', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[searchfileld]" <?php echo (($isNew && $defaults['searchfileld']) || isset($slider['searchfileld'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('With enabled search field your users can enter their own locations.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Always show search field', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[alwaysshowsearchfileld]" <?php echo (($isNew && $defaults['alwaysshowsearchfileld']) || isset($slider['alwaysshowsearchfileld'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('By enabling this option the search field will always be visible.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show weather info', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[weatherinfo]" <?php echo (($isNew && $defaults['weatherinfo']) || isset($slider['weatherinfo'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the weather information box.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show forecast', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[forecast]" <?php echo (($isNew && $defaults['forecast']) || isset($slider['forecast'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the 3 days forecast when you hover over the information box.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Always show forecast', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[alwaysshowforecast]" <?php echo (($isNew && $defaults['alwaysshowforecast']) || isset($slider['alwaysshowforecast'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('By enabling this option the forecast information will always be visible.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Enable CSS3 Animations', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[cssanimations]" <?php echo (($isNew && $defaults['cssanimations']) || isset($slider['cssanimations']) )? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Using CSS3 animations can drastically improve performance in modern web browsers, especially on mobile devices.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Enable Javascript animations', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[jsanimations]" <?php echo (($isNew && $defaults['jsanimations']) || isset($slider['jsanimations'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e("By disabling this and the CSS3 animations the plugin won't animate snow, rain, wind and lightnings.", WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Infobox animation duration', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[infoduration]" value="<?php echo !empty($slider['infoduration']) ? $slider['infoduration'] : '450' ?>"></td>
						<td class="desc"><?php _e('The animation duration when the information box appears. This value in milliseconds, so the value 1000 means one second.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Infobox easingIn', WS_TEXTDOMAIN) ?></td>
						<td>
							<select name="slider_data[infoboxeasingin]">
								<option<?php echo ($slider['infoboxeasingin'] == 'linear' ) ? ' selected="selected"' : '' ?>>linear</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'swing' ) ? ' selected="selected"' : '' ?>>swing</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInQuad' ) ? ' selected="selected"' : '' ?>>easeInQuad</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutQuad' ) ? ' selected="selected"' : '' ?>>easeOutQuad</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutQuad' ) ? ' selected="selected"' : '' ?>>easeInOutQuad</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInCubic' ) ? ' selected="selected"' : '' ?>>easeInCubic</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutCubic' ) ? ' selected="selected"' : '' ?>>easeOutCubic</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutCubic' ) ? ' selected="selected"' : '' ?>>easeInOutCubic</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInQuart' ) ? ' selected="selected"' : '' ?>>easeInQuart</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutQuart' ) ? ' selected="selected"' : '' ?>>easeOutQuart</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutQuart' ) ? ' selected="selected"' : '' ?>>easeInOutQuart</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInQuint' ) ? ' selected="selected"' : '' ?>>easeInQuint</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutQuint' ) ? ' selected="selected"' : '' ?>>easeOutQuint</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutQuint' ) ? ' selected="selected"' : '' ?>>easeInOutQuint</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInSine' ) ? ' selected="selected"' : '' ?>>easeInSine</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutSine' ) ? ' selected="selected"' : '' ?>>easeOutSine</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutSine' ) ? ' selected="selected"' : '' ?>>easeInOutSine</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInExpo' ) ? ' selected="selected"' : '' ?>>easeInExpo</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutExpo' ) ? ' selected="selected"' : '' ?>>easeOutExpo</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutExpo' ) ? ' selected="selected"' : '' ?>>easeInOutExpo</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInCirc' ) ? ' selected="selected"' : '' ?>>easeInCirc</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutCirc' ) ? ' selected="selected"' : '' ?>>easeOutCirc</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutCirc' ) ? ' selected="selected"' : '' ?>>easeInOutCirc</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInElastic' ) ? ' selected="selected"' : '' ?>>easeInElastic</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutElastic' ) ? ' selected="selected"' : '' ?>>easeOutElastic</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutElastic' ) ? ' selected="selected"' : '' ?>>easeInOutElastic</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInBack' ) ? ' selected="selected"' : '' ?>>easeInBack</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutBack' ) ? ' selected="selected"' : '' ?>>easeOutBack</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutBack' ) ? ' selected="selected"' : '' ?>>easeInOutBack</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInBounce' ) ? ' selected="selected"' : '' ?>>easeInBounce</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeOutBounce' ) ? ' selected="selected"' : '' ?>>easeOutBounce</option>
								<option<?php echo ($slider['infoboxeasingin'] == 'easeInOutBounce' ) ? ' selected="selected"' : '' ?>>easeInOutBounce</option>
							</select>
						</td>
						<td class="desc"><?php _e('The preferred animation easing when the information box appears.', WS_TEXTDOMAIN) ?> <a href="http://easings.net/" target="_blank"><?php _e('See examples') ?></a></td>
					</tr>
					<tr>
						<td><?php _e('Infobox easingOut', WS_TEXTDOMAIN) ?></td>
						<td>
							<select name="slider_data[infoboxeasingout]">
								<option<?php echo ($slider['infoboxeasingout'] == 'linear' ) ? ' selected="selected"' : '' ?>>linear</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'swing' ) ? ' selected="selected"' : '' ?>>swing</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInQuad' ) ? ' selected="selected"' : '' ?>>easeInQuad</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutQuad' ) ? ' selected="selected"' : '' ?>>easeOutQuad</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutQuad' ) ? ' selected="selected"' : '' ?>>easeInOutQuad</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInCubic' ) ? ' selected="selected"' : '' ?>>easeInCubic</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutCubic' ) ? ' selected="selected"' : '' ?>>easeOutCubic</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutCubic' ) ? ' selected="selected"' : '' ?>>easeInOutCubic</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInQuart' ) ? ' selected="selected"' : '' ?>>easeInQuart</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutQuart' ) ? ' selected="selected"' : '' ?>>easeOutQuart</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutQuart' ) ? ' selected="selected"' : '' ?>>easeInOutQuart</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInQuint' ) ? ' selected="selected"' : '' ?>>easeInQuint</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutQuint' ) ? ' selected="selected"' : '' ?>>easeOutQuint</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutQuint' ) ? ' selected="selected"' : '' ?>>easeInOutQuint</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInSine' ) ? ' selected="selected"' : '' ?>>easeInSine</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutSine' ) ? ' selected="selected"' : '' ?>>easeOutSine</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutSine' ) ? ' selected="selected"' : '' ?>>easeInOutSine</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInExpo' ) ? ' selected="selected"' : '' ?>>easeInExpo</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutExpo' ) ? ' selected="selected"' : '' ?>>easeOutExpo</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutExpo' ) ? ' selected="selected"' : '' ?>>easeInOutExpo</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInCirc' ) ? ' selected="selected"' : '' ?>>easeInCirc</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutCirc' ) ? ' selected="selected"' : '' ?>>easeOutCirc</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutCirc' ) ? ' selected="selected"' : '' ?>>easeInOutCirc</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInElastic' ) ? ' selected="selected"' : '' ?>>easeInElastic</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutElastic' ) ? ' selected="selected"' : '' ?>>easeOutElastic</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutElastic' ) ? ' selected="selected"' : '' ?>>easeInOutElastic</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInBack' ) ? ' selected="selected"' : '' ?>>easeInBack</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutBack' ) ? ' selected="selected"' : '' ?>>easeOutBack</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutBack' ) ? ' selected="selected"' : '' ?>>easeInOutBack</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInBounce' ) ? ' selected="selected"' : '' ?>>easeInBounce</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeOutBounce' ) ? ' selected="selected"' : '' ?>>easeOutBounce</option>
								<option<?php echo ($slider['infoboxeasingout'] == 'easeInOutBounce' ) ? ' selected="selected"' : '' ?>>easeInOutBounce</option>
							</select>
						</td>
						<td class="desc"><?php _e('The preferred animation easing when the information box hides.', WS_TEXTDOMAIN) ?> <a href="http://easings.net/" target="_blank"><?php _e('See examples') ?></a></td>
					</tr>
					<tr>
						<td><?php _e('Reduction', WS_TEXTDOMAIN) ?></td>
						<td><input type="text" name="slider_data[reduction]" value="<?php echo !empty($slider['reduction']) ? $slider['reduction'] : 'auto' ?>"></td>
						<td class="desc"><?php _e("The script automatically scales everything (graphic elements, font sizes, etc) depending on the width and height of the container. Use 'auto' or override it with a number between 0 and 1.", WS_TEXTDOMAIN) ?></td>
					</tr>
				</tbody>
				<thead>
					<tr>
						<td colspan="3">
							<span class="dashicons dashicons-text"></span>
							<h4><?php _e('Contents of the information box', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Show location', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showlocation]" <?php echo (($isNew && $defaults['showlocation']) || isset($slider['showlocation'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the current location.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show time', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showtime]" <?php echo (($isNew && $defaults['showtime']) || isset($slider['showtime'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the current time.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show current conditions', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showconditions]" <?php echo (($isNew && $defaults['showconditions']) || isset($slider['showconditions'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the current weather conditions.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show temperature', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showtemperature]" <?php echo (($isNew && $defaults['showtemperature']) || isset($slider['showtemperature'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the current temperature.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show low temperature', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showlowtemp]" <?php echo (($isNew && $defaults['showlowtemp']) || isset($slider['showlowtemp'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides low temperature.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show high temperature', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showhightemp]" <?php echo (($isNew && $defaults['showhightemp']) || isset($slider['showhightemp'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides high temperature.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show humidity', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showhumidity]" <?php echo (($isNew && $defaults['showhumidity']) || isset($slider['showhumidity'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides humidity.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show precipitation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showprec]" <?php echo (($isNew && $defaults['showprec']) || isset($slider['showprec'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides precipitation.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show wind', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showwind]" <?php echo (($isNew && $defaults['showwind']) || isset($slider['showwind'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides wind.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show pressure', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showpress]" <?php echo (($isNew && $defaults['showpress']) || isset($slider['showpress'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides pressure.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show visibility', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showvisibility]" <?php echo (($isNew && $defaults['showvisibility']) || isset($slider['showvisibility'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides visibility.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show forecast day', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showfday]" <?php echo (($isNew && $defaults['showfday']) || isset($slider['showfday'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides the name of the day in the forecast.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show forecast condition', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showfcondition]" <?php echo (($isNew && $defaults['showfcondition']) || isset($slider['showfcondition'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides weather conditions in the forecast.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show forecast low temperature', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showflow]" <?php echo (($isNew && $defaults['showflow']) || isset($slider['showflow'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides low temperature in the forecast.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Show forecast high temperature', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[showfhigh]" <?php echo (($isNew && $defaults['showfhigh']) || isset($slider['showfhigh'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Shows / hides high temperature in the forecast.', WS_TEXTDOMAIN) ?></td>
					</tr>

					<tr>
				</tbody>
				<thead>
					<tr>
						<td colspan="3">
							<span class="dashicons dashicons-image-flip-horizontal"></span>
							<h4><?php _e('Animation settings', WS_TEXTDOMAIN) ?></h4>
						</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?php _e('Enable snow animation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[snow]" <?php echo (($isNew && $defaults['snow']) || isset($slider['snow'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Enables / disables the snowing animation.', WS_TEXTDOMAIN) ?></td>
					</tr>

					<tr>
						<td><?php _e('Enable rain animation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[rain]" <?php echo (($isNew && $defaults['rain']) || isset($slider['rain'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Enables / disables the raining animation.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Enable wind animation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[wind]" <?php echo (($isNew && $defaults['wind']) || isset($slider['wind'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Enables / disables the "Windy weather" animation.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Enable lightnings animation', WS_TEXTDOMAIN) ?></td>
						<td><input type="checkbox" name="slider_data[lightnings]" <?php echo (($isNew && $defaults['lightnings']) || isset($slider['lightnings'])) ? 'checked="checked"' : '' ?>></td>
						<td class="desc"><?php _e('Enables / disables the lightning animation.', WS_TEXTDOMAIN) ?></td>
					</tr>
					<tr>
						<td><?php _e('Wind direction', WS_TEXTDOMAIN) ?></td>
						<td>
							<select name="slider_data[winddirection]">
								<option value="auto" <?php echo (!empty($slider['winddirection']) && $slider['winddirection'] == 'auto') ? 'selected="selected"' : '' ?>><?php _e('Automatic', WS_TEXTDOMAIN) ?></option>
								<option value="left" <?php echo (!empty($slider['winddirection']) && $slider['winddirection'] == 'left') ? 'selected="selected"' : '' ?>><?php _e('Left', WS_TEXTDOMAIN) ?></option>
								<option value="right" <?php echo (!empty($slider['winddirection']) && $slider['winddirection'] == 'right') ? 'selected="selected"' : '' ?>><?php _e('Right', WS_TEXTDOMAIN) ?></option>
							</select>
						</td>
						<td class="desc"><?php _e('You can set the direction of the background animation for windy weather.', WS_TEXTDOMAIN) ?></td>
					</tr>
				</tbody>
			</table>
		</div>
		<!-- End of Global Settings -->


		<div class="ws-publish">
			<button class="button button-primary button-hero"><?php _e('Save changes', WS_TEXTDOMAIN) ?></button>
			<div class="ws-save-shortcode">
				<p><span>Use shortcode:</span><br><span>[weatherslider id="<?php echo !empty($slider['slug']) ? $slider['slug'] : ($sliderid+1) ?>"]</span></p>
				<p><span>Use PHP function:</span><br><span>&lt;?php weatherslider(<?php echo !empty($slider['slug']) ? "'{$slider['slug']}'" : ($sliderid+1) ?>) ?&gt;</span></p>
			</div>
		</div>
	</form>
</div>