<?php

	if(!defined('WS_ROOT_FILE')) {
		header('HTTP/1.0 403 Forbidden');
		exit;
	}

	// Enqueue scripts
	wp_enqueue_script('google-maps');
	wp_enqueue_script('background_position');
	wp_enqueue_script('jquery_easing');
	wp_enqueue_script('weatherslider_js');

	include WS_ROOT_PATH . '/config/lang.defaults.php';
	include WS_ROOT_PATH . '/config/slider.defaults.php';

	// Get API key
	$api_key = trim(get_option('weatherslider-apikey', ''));
	$api_version = get_option('weatherslider-api-version', '1');
	$premium_api = get_option('weatherslider-premium-api', true);
	$premium_api = !empty($premium_api) ? 'true' : 'false';
	$ssl_support = get_option('weatherslider-ssl-support', true);
	$ssl_support = !empty($ssl_support) ? 'true' : 'false';


	// Cache support
	$caching_support = get_option('weatherslider-caching-support', '');

	// Get langunage support
	$lang_support = get_option('weatherslider-language-support', '');

	// Get language strings
	$lang = get_option('weatherslider-lang-strings');
	$lang = !empty($lang) ? json_decode($lang, true) : array();

	// Slider settings
	foreach($wsSliderDefaults as $item) {
		if(is_bool($item['value']) && isset($slider[$item['key']])) {
			$slider[$item['key']] = 'true';

		} elseif(is_bool($item['value']) && !isset($slider[$item['key']])) {
			$slider[$item['key']] = 'false';

		} elseif(isset($slider[$item['key']])) {
			$slider[$item['key']] = is_numeric($slider[$item['key']]) ? (float) $slider[$item['key']] : stripslashes($slider[$item['key']]);
		}
	}


	// Language strings
	foreach($wsLangDefaults as $item) {

		// Set default if needed
		if(empty($lang[$item['key']])) { $lang[ $item['key']] = $item['value']; }

		// Get WPML localized string (if any)
		if(function_exists('icl_t')) {
			$lang[$item['key']] = icl_t('WeatherSlider WP', $item['key'], $item['value']);
		}

		// Set lang string
		$lang[$item['key']] = do_shortcode(__(stripslashes($lang[$item['key']])));
	}


	// Defaults: settings
	$slider['reduction'] = !empty($slider['reduction']) ? $slider['reduction'] : 'auto';
	$slider['reduction'] = is_numeric($slider['reduction']) ? $slider['reduction'] : '\'auto\'';

// Fix multiple jQuery issue
$ret .= '<script type="text/javascript">';
$ret .= 'var wsjQuery = jQuery;';
$ret .= '</script>';

// Include JS files to body option
if(get_option('ws_put_js_to_body', false)) {
    $ret .= '<script type="text/javascript" src="'.WS_ROOT_URL.'/js/jquery-animate-background-position.js?ver='.WS_PLUGIN_VERSION.'"></script>' . NL;
    $ret .= '<script type="text/javascript" src="'.WS_ROOT_URL.'/js/jquery-easing-1.3.js?ver=1.3.0"></script>' . NL;
    $ret .= '<script type="text/javascript" src="'.WS_ROOT_URL.'/js/weatherslider.kreaturamedia.jquery.js?ver='.WS_PLUGIN_VERSION.'"></script>' . NL;
}


$ret .= '<script type="text/javascript">
	wsjQuery(document).ready(function(){
		wsjQuery("#weatherslider_'.$id.'").weatherSlider({' . NL;

			$ret .= ' ajaxURL           : \''.admin_url('admin-ajax.php').'\',
			responsive        : '.$slider['responsive'].',
			imgPath           : \''.plugins_url('/img/', __FILE__).'\',
			WWOAPIVersion	  : '.$api_version.',
			premiumAPIKey	  : '.$premium_api.',
			useHTTPS	  	  : '.$ssl_support.',
			measurement       : \''.$slider['measurement'].'\',
			timeFormat        : '.$slider['timeformat'].',
			daytime           : ['.$slider['daytime'].'],
			windyWeather      : '.$slider['windyweather'].',
			icyTemp           : '.$slider['icytemp'].',
			slideDelay        : '.$slider['slidedelay'].',
			refreshInterval   : '.$slider['refreshinterval'].',
			keybNav           : '.$slider['keybnav'].',
			touchNav          : '.$slider['touchnav'].',
			hideBackground    : '.$slider['background'].',
			enableSearchField : '.$slider['searchfileld'].',
			alwaysShowSearch  : '.$slider['alwaysshowsearchfileld'].',
			enableWeatherInfo : '.$slider['weatherinfo'].',
			enableForecast    : '.$slider['forecast'].',
			alwaysShowForecast: '.$slider['alwaysshowforecast'].',
			CSSanimations     : '.$slider['cssanimations'].',
			JSanimations      : '.$slider['jsanimations'].',
			infoDuration      : '.$slider['infoduration'].',
			infoEasingType	  : [\''.$slider['infoboxeasingin'].'\', \''.$slider['infoboxeasingout'].'\'],
			reduction         : '.$slider['reduction'].',
			showLoc           : '.$slider['showlocation'].',
			showTime          : '.$slider['showtime'].',
			showCond          : '.$slider['showconditions'].',
			showTemp          : '.$slider['showtemperature'].',
			showLow           : '.$slider['showlowtemp'].',
			showHigh          : '.$slider['showhightemp'].',
			showHum           : '.$slider['showhumidity'].',
			showPrec          : '.$slider['showprec'].',
			showWind          : '.$slider['showwind'].',
			showPress         : '.$slider['showpress'].',
			showVis           : '.$slider['showvisibility'].',
			showFDay          : '.$slider['showfday'].',
			showFCond         : '.$slider['showfcondition'].',
			showFLow          : '.$slider['showflow'].',
			showFHigh         : '.$slider['showfhigh'].',
			snow			  : '.$slider['snow'].',
			rain		      : '.$slider['rain'].',
			wind			  : '.$slider['wind'].',
			lightnings	      : '.$slider['lightnings'].',
			windDirection	  : \''.$slider['winddirection'].'\'';

			if($lang_support != '') {
			$ret .= NL . ',language : {
				cl	: \''.$lang['cl'].'\',
				ht	: \''.$lang['ht'].'\',
				lt	: \''.$lang['lt'].'\',
				hu	: \''.$lang['hu'].'\',
				pr	: \''.$lang['pr'].'\',
				wi	: \''.$lang['wi'].'\',
				ps	: \''.$lang['ps'].'\',
				vi	: \''.$lang['vi'].'\',
				get	: \''.$lang['get'].'\',
				not	: \''.$lang['not'].'\',
				una	: \''.$lang['una'].'\',
				search	: \''.$lang['search'].'\',
				am	: \''.$lang['am'].'\',
				pm	: \''.$lang['pm'].'\',
				day	: \''.$lang['day'].'\',
				\'113\'	: \''.$lang['c_113'].'\',
				\'114\'	: \''.$lang['c_114'].'\',
				\'115\'	: \''.$lang['c_115'].'\',
				\'116\'	: \''.$lang['c_116'].'\',
				\'119\'	: \''.$lang['c_119'].'\',
				\'122\'	: \''.$lang['c_122'].'\',
				\'143\'	: \''.$lang['c_143'].'\',
				\'176\'	: \''.$lang['c_176'].'\',
				\'179\'	: \''.$lang['c_179'].'\',
				\'182\'	: \''.$lang['c_182'].'\',
				\'185\'	: \''.$lang['c_185'].'\',
				\'200\'	: \''.$lang['c_200'].'\',
				\'227\'	: \''.$lang['c_227'].'\',
				\'230\'	: \''.$lang['c_230'].'\',
				\'248\'	: \''.$lang['c_248'].'\',
				\'260\'	: \''.$lang['c_260'].'\',
				\'263\'	: \''.$lang['c_263'].'\',
				\'266\'	: \''.$lang['c_266'].'\',
				\'281\'	: \''.$lang['c_281'].'\',
				\'284\'	: \''.$lang['c_284'].'\',
				\'293\'	: \''.$lang['c_293'].'\',
				\'296\'	: \''.$lang['c_296'].'\',
				\'299\'	: \''.$lang['c_299'].'\',
				\'302\'	: \''.$lang['c_302'].'\',
				\'305\'	: \''.$lang['c_305'].'\',
				\'308\'	: \''.$lang['c_308'].'\',
				\'311\'	: \''.$lang['c_311'].'\',
				\'314\'	: \''.$lang['c_314'].'\',
				\'317\'	: \''.$lang['c_317'].'\',
				\'320\'	: \''.$lang['c_320'].'\',
				\'323\'	: \''.$lang['c_323'].'\',
				\'326\'	: \''.$lang['c_326'].'\',
				\'329\'	: \''.$lang['c_329'].'\',
				\'332\'	: \''.$lang['c_332'].'\',
				\'335\'	: \''.$lang['c_335'].'\',
				\'338\'	: \''.$lang['c_338'].'\',
				\'350\'	: \''.$lang['c_350'].'\',
				\'353\'	: \''.$lang['c_353'].'\',
				\'356\'	: \''.$lang['c_356'].'\',
				\'359\'	: \''.$lang['c_359'].'\',
				\'362\'	: \''.$lang['c_362'].'\',
				\'365\'	: \''.$lang['c_365'].'\',
				\'368\'	: \''.$lang['c_368'].'\',
				\'371\'	: \''.$lang['c_371'].'\',
				\'374\'	: \''.$lang['c_374'].'\',
				\'377\'	: \''.$lang['c_377'].'\',
				\'386\'	: \''.$lang['c_386'].'\',
				\'389\'	: \''.$lang['c_389'].'\',
				\'392\'	: \''.$lang['c_392'].'\',
				\'395\'	: \''.$lang['c_395'].'\'
				}';
			}
		$ret .= '});
  });
</script>';