(function( $ ) {

	$.fn.customCheckbox = function() {

		return this.each(function() {

			// Get the original element
			var el = this;

			// Hide the checkbox
			$(this).hide();

			// Create replacement element
			var rep = $('<a href="#"><span></span></a>').addClass('ws-checkbox').insertAfter(this);

			// Add name class
			rep.addClass( jQuery(this).attr('name') );

			// Set default state
			if($(this).is(':checked')) {
				$(rep).addClass('on');
			} else {
				$(rep).addClass('off');
			}

			// Click event
			$(rep).click(function(e) {

				e.preventDefault();

				if( $(el).is(':checked') ) {
					$(el).prop('checked', false);
					$(rep).removeClass('on').addClass('off');
				} else {
					$(el).prop('checked', true);
					$(rep).removeClass('off').addClass('on');
				}
			});
		});
	};

})( jQuery );


var wsTooltip = {
	timeout : 0,

	init : function() {

		jQuery(document).on('mouseover', '[data-help]', function() {
			var el = this;
			wsTooltip.timeout = setTimeout(function() {
				wsTooltip.open(el);
			}, 400);
		});

		jQuery(document).on('mouseout', '[data-help]', function() {
			clearTimeout(wsTooltip.timeout);
			wsTooltip.close();
		});
	},

	destroy : function() {

		jQuery(document).off('mouseover', '[data-help]');
		jQuery(document).off('mouseout', '[data-help]');
	},

	open : function(el) {

		// Create tooltip
		jQuery('body').prepend( jQuery('<div>', { 'class' : 'ws-tooltip' })
			.append( jQuery('<div>', { 'class' : 'inner' }))
			.append( jQuery('<span>') )
		);

		// Get tooltip
		var tooltip = jQuery('.ws-tooltip');

		// Set tooltip text
		tooltip.find('.inner').text( jQuery(el).attr('data-help'));

		// Get viewport dimensions
		var v_w = jQuery(window).width();

		// Get element dimensions
		var e_w = jQuery(el).width();

		// Get element position
		var e_l = jQuery(el).offset().left;
		var e_t = jQuery(el).offset().top;

		// Get toolip dimensions
		var t_w = tooltip.outerWidth();
		var t_h = tooltip.outerHeight();

		// Position tooltip
		tooltip.css({ top : e_t - t_h - 10, left : e_l - (t_w - e_w) / 2  });
		// Fix right position
		if(tooltip.offset().left + t_w > v_w) {
			tooltip.css({ 'left' : 'auto', 'right' : 10 });
			tooltip.find('span').css({ left : 'auto', right : v_w - jQuery(el).offset().left - jQuery(el).outerWidth() / 2 - 17, marginLeft : 'auto' });
		}

	},

	close : function() {
		jQuery('.ws-tooltip').remove();
	}
};

var WS_BoxToggles = {

	init : function() {
		jQuery('.ws-box-toggle').click(function() {

			// Get parent
			var parent = jQuery(this).closest('.ws-box');
			var button = jQuery(this);

			// Check state
			if(parent.hasClass('collapsed')) {
				parent.removeClass('collapsed');
				button.removeClass('dashicons-arrow-right').addClass('dashicons-arrow-down');

			} else {
				parent.addClass('collapsed');
				button.removeClass('dashicons-arrow-down').addClass('dashicons-arrow-right');
			}
		});
	}
};

var WeatherSlider = {

	timeout : 0,
	geocoder : null,

	init : function() {

		// Get geocoder
		WeatherSlider.geocoder = new google.maps.Geocoder();
		wsTooltip.init();
	},

	selectMainTab : function(el) {

		// Remove highlight from the other tabs
		jQuery('#ws-main-nav-bar a').removeClass('active');

		// Highlight selected tab
		jQuery(el).addClass('active');

		// Hide other pages
		jQuery('#ws-pages .ws-page').removeClass('active');

		// Show selected page
		jQuery('#ws-pages .ws-page').eq( jQuery(el).index() ).addClass('active')
	},

	addLocation : function(el) {

		// Location input
		var location = jQuery('#ws-location-input').val();

		// Warning when no location entered
		if(location == '') {
			alert('You must enter a location name to add it to your list!');
			return;
		}

		// Append new element
		jQuery('#ws-location-list').append( jQuery('<li>')
			.append( jQuery('<span>', { 'class' : 'ws-icon-move dashicons dashicons-editor-justify' }))
			.append( jQuery('<input>', { 'type' : 'text', 'name' : 'slider_data[locations][]', 'value' : location }))
			.append( jQuery('<input>', { 'class' : 'ws-editor-location-title', 'type' : 'text', 'name' : 'slider_data[titles][]', 'placeholder' : 'Custom location name' }))
			.append( jQuery('<span>', { 'class' : 'ws-icon-remove dashicons dashicons-dismiss' }))
			.append( jQuery('<div>', { 'class' : 'clear' }))
		);

		// Reset location field
		jQuery('#ws-location-input').val('');

		// Remove notice if any
		if(jQuery('.ws-location-notice').length > 0) {
			jQuery('.ws-location-notice').remove();
		}

		// Add sortables
		WeatherSlider.addSortables();
	},

	removeLocation : function(el) {

		// Add notice if needed
		if(jQuery('#ws-location-list').children().length < 2) {
			jQuery('#ws-location-list').prepend( jQuery('<li>', { 'class' : 'ws-location-notice', text : 'You didn\'t add any location yet.' }));
		}

		// Remove location from the list
		jQuery(el).parent().remove();
	},

	addSortables : function() {

		// Bind sortable function
	    jQuery('#ws-location-list').sortable({
	    	axis : 'y',
	        containment : 'parent',
	        handle : '.ws-icon-move',
			tolerance : 'pointer'
	    });
	},

	willAutocomplete : function(el) {

		clearTimeout(WeatherSlider.timeout);
		WeatherSlider.timeout = setTimeout(function() {
			WeatherSlider.autocomplete(el);
		}, 750);
	},

	autocomplete : function(el) {

		// Get location input box
		var location = jQuery(el).val();

		// Do nothing if there is no location
		if(location.length < 2) {
			WeatherSlider.closeOverlay();
			return;
		}

		// Results list
		var list = jQuery(el).next();

		// Reset results
		list.children().remove();

		// Make request
		WeatherSlider.geocoder.geocode( { 'address': location }, function(results, status) {
			if (status == google.maps.GeocoderStatus.OK) {

				// Create overlay
				WeatherSlider.createOverlay();

				var city, country;

				// Populat the results
				for(z = 0; z < results.length; z++) {

					city = '';
					country = '';

					for(i = 0; i < results[z].address_components.length; i++) {
						for(c = 0; c < results[z].address_components[i].types.length; c++) {

							// City
							if(results[z].address_components[i].types[c] == 'locality') {
								var city = results[z].address_components[i].long_name;
							}

							// Country
							if(results[z].address_components[i].types[c] == 'country') {
								var country = results[z].address_components[i].long_name;
							}
						}
					}

					// Add location if any
					if(city != '' && country != '') {
						list.show();
						list.append( jQuery('<li>', { text : ''+city+', '+country+''  }));
					}
				}
			}
	    });
	},

	createOverlay : function() {

		jQuery('body').click(function() {
			WeatherSlider.closeOverlay();
		});
	},

	closeOverlay : function() {

		// Remove close event from body
		jQuery('body').unbind('click');

		// Hide overlay and autocomplete
		jQuery('#ws-location-autocomplete').hide();
		jQuery('#ws-overlay').remove();
	}
};


jQuery(document).ready(function() {

	// Remove confirm
	jQuery('.ws-slider-list a.remove').click(function(e) {
		e.preventDefault();
		if(confirm('Are you sure you want to remove this slider?')) {
			document.location.href = jQuery(this).attr('href');
		}
	});

	// Main tab bar page select
	jQuery('#ws-main-nav-bar a:not(.unselectable)').click(function(e) {
		e.preventDefault();
		WeatherSlider.selectMainTab( this );
	});

	// Documentation menu item
	jQuery('#ws-main-nav-bar a.support').click(function(e) {
		e.preventDefault();
		jQuery('#contextual-help-link').click();
	});

	// Auto-update
	jQuery('.ws-auto-update').submit(function(e) {

		// Prevent browser default submission
		e.preventDefault();

		// Set progress text
		jQuery('.ws-auto-update tfoot span').text('Validating ...').css('color', '#333');

		// Post it
		jQuery.post( ajaxurl, jQuery(this).serialize(), function(data) {

			// Parse data
			data = jQuery.parseJSON(data);

			// Check success
			jQuery('.ws-auto-update tfoot span').html(data['message']);

			// Check success
			if(data['success'] == true) {
				jQuery('.ws-auto-update tfoot span').css('color', '#4b982f');
			} else {
				jQuery('.ws-auto-update tfoot span').css('color', '#c33219');
			}
		});
	});

	// Settings: checkboxes
	jQuery('.ws-settings input:checkbox').customCheckbox();

	// Cache folder check
	if(jQuery('input[name="weatherslider-caching-support"]').hasClass('notwritable')) {
		jQuery('.ws-checkbox.weatherslider-caching-support').unbind('click').click(function(e) {

			// Prevent the default submission of the browser
			e.preventDefault();

			// Append notice
			if(!jQuery(this).closest('tr').next().is('tr.ws-cache-notice')) {
				jQuery(this).closest('tr').after( jQuery('<tr>', { 'class' : 'ws-cache-notice' })
					.append( jQuery('<td>', { 'colspan' : '3' })
						.append( jQuery('<p>', { 'html' : 'You need to make the cache folder writable before you can save your changes. See the <a href="http://codex.wordpress.org/Changing_File_Permissions" target="_blank">Codex</a> for more information about changing file and folder permissions. When you finished, please refresh this page and try to enable this option again.' }))
					)
				);
			}

			// Fade in notice
			jQuery('tr.ws-cache-notice p').hide().fadeIn(300);
		});
	}

	// Show language string if enabled
	if(jQuery('input[name="weatherslider-language-support"]').prop('checked') == true) {
		jQuery('.ws-language .hideable').show();
	}

	// Show language string event
	jQuery(document).on('click', '.weatherslider-language-support', function() {

		if(jQuery(this).hasClass('on')) {
			jQuery('.ws-language .hideable').show();
		} else {
			jQuery('.ws-language .hideable').hide();
		}
	});

	WeatherSlider.init();

	// Generator: location autocomplete
	jQuery(document).on('keyup', '#ws-location-input', function() {
		WeatherSlider.willAutocomplete(this);
	});

	// Generator: location by autocomplete
	jQuery(document).on('click', '#ws-location-autocomplete li', function() {
		jQuery(this).parent().prev().val( jQuery(this).text() );
		jQuery('#ws-location-add').click();
	});

	// Generator: add location
	jQuery(document).on('click', '#ws-location-add', function(e) {
		e.preventDefault();
		WeatherSlider.addLocation(this);
	});

	// Generator: remove location
	jQuery(document).on('click', '.ws-icon-remove', function() {
		WeatherSlider.removeLocation(this);
	});

	// Generator: sortables
	WeatherSlider.addSortables();

	// News filters
	jQuery('.ws-news .filters li').click(function() {

		// Highlight
		jQuery(this).siblings().attr('class', '');
		jQuery(this).attr('class', 'active');

		// Get stuff
		var page = jQuery(this).data('page');
		var frame = jQuery(this).closest('.ws-box').find('iframe');
		var baseUrl = frame.attr('src').split('#')[0];

		// Set filter
		frame.attr('src', baseUrl+'#'+page);

	});

	// Add slider
	jQuery('#ws-add-slider-button').click(function(e) {
		e.preventDefault();
		var offsets = jQuery(this).position();
		var popup = jQuery('#ws-add-slider-template');

		popup.css({
			top : offsets.top + 35,
			left : offsets.left - popup.outerWidth() / 2 + jQuery(this).width() / 2 + 7
		}).show().animate({ marginTop : 0, opacity : 1 }, 150, function() {
			jQuery(this).find('.inner input').focus();
		});

		jQuery('<div>', { 'class' : 'ws-overlay ws-add-slider-overlay'}).prependTo('body');
	});

	// Close add slider window
	jQuery(document).on('click', '.ws-overlay', function() {
		if(jQuery('.ws-pointer').length) {
			jQuery('.ws-overlay').remove();
			jQuery('.ws-pointer').animate({ marginTop : 40, opacity : 0 }, 150);
		}
	});

	// Slider remove
	jQuery('.ws-sliders-list a.remove').click(function(e) {
		e.preventDefault();
		if(confirm('Are you sure you want to remove this slider?')){
			document.location.href = jQuery(this).attr('href');
		}
	});

	// Shortcode
	jQuery('input.ws-shortcode').click(function() {
		this.focus();
		this.select();
	});

	WS_BoxToggles.init();
});