<?php

	if(!defined('WS_ROOT_FILE')) {
		header('HTTP/1.0 403 Forbidden');
		exit;
	}

	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Get global plugin settings
	$api_key = trim(get_option('weatherslider-apikey', ''));
	$api_version = get_option('weatherslider-api-version', '1');
	$premium_api = get_option('weatherslider-premium-api', true);
	$ssl_support = get_option('weatherslider-ssl-support', true);
	$caching_support = get_option('weatherslider-caching-support', '');
	$cache_interval = get_option('weatherslider-caching-update-interval', '30');
	$lang_support = get_option('weatherslider-language-support', '');
	$custom_capability = get_option('weatherslider-custom-capability', 'manage_options');

	// Get language strings
	$lang = get_option('weatherslider-lang-strings');
	$lang = !empty($lang) ? json_decode($lang, true) : array();

	// Cache folder
	$cache_folder = dirname(__FILE__) . '/cache/';

	// Check cache folder permissions
	if(!is_writable($cache_folder)) {
		$cache_class = 'class="notwritable"';
	} else {
		$cache_class = '';
	}

	// Auto-updates
	$code = get_option('weatherslider-purchase-code', '');
	if(!empty($code)) {
		$start = substr($code, 0, -6);
		$end = substr($code, -6);
		$code = preg_replace("/[a-zA-Z0-9]/", '●', $start) . $end;
		$code = str_replace('-', ' ', $code);
	}

	$validity = get_option('weatherslider-validated', '0');
	$channel = get_option('weatherslider-release-channel', 'stable');

?>
<div class="wrap">
	<h2>
		<?php _e('WeatherSlider sliders', WS_TEXTDOMAIN) ?>
		<a href="#" id="ws-add-slider-button" class="add-new-h2"><?php _e('Add New', WS_TEXTDOMAIN) ?></a>
	</h2>

	<!-- Add slider template -->
	<form action="<?php echo $_SERVER['REQUEST_URI'] ?>" method="post" id="ws-add-slider-template" class="ws-pointer ws-box">
		<?php wp_nonce_field('ws-add-slider'); ?>
		<input type="hidden" name="ws_posted_add" value="1">
		<input type="hidden" name="ws-add-new-slider" value="1">
		<span class="ws-mce-arrow"></span>
		<h3 class="header"><?php _e('Give a name to your new slider', WS_TEXTDOMAIN) ?></h3>
		<div class="inner">
			<input type="text" name="title" placeholder="<?php _e('e.g. a location name', WS_TEXTDOMAIN) ?>">
			<button class="button"><?php _e('Add slider', WS_TEXTDOMAIN) ?></button>
		</div>
	</form>
	<!-- End of Add slider template -->

	<!-- Main menu -->
	<div id="ws-main-nav-bar">
		<a href="#" class="settings active"><i class="dashicons dashicons-admin-tools"></i> <?php _e('Sliders & Settings', WS_TEXTDOMAIN) ?></a>
		<a href="#" class="language"><i class="dashicons dashicons-translation"></i> <?php _e('Language', WS_TEXTDOMAIN) ?></a>
		<a href="#" class="updates"><i class="dashicons dashicons-update"></i> <?php _e('News & Updates', WS_TEXTDOMAIN) ?></a>
		<a href="https://support.kreaturamedia.com/faq/3/weatherslider-for-wordpress/" target="_blank" class="faq right unselectable"><i class="dashicons dashicons-sos"></i> FAQ</a>
		<a href="#" class="support right unselectable"><i class="dashicons dashicons-editor-help"></i> <?php _e('Documentation', WS_TEXTDOMAIN) ?></a>
		<span class="right help">Need help? Try these:</span>
		<a href="#" class="clear unselectable"></a>
	</div>

	<!-- Pages -->
	<div id="ws-pages">
		<form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post">
			<input type="hidden" name="ws_posted_global" value="1">
			<?php wp_nonce_field('ws-save-globals'); ?>

			<!-- Sliders & Settings -->
			<div class="ws-page active">

				<!-- Slider list -->
				<div class="ws-box ws-sliders-list">
					<table>
						<thead class="header">
							<tr>
								<td><?php _e('ID', WS_TEXTDOMAIN) ?></td>
								<td><?php _e('Name', WS_TEXTDOMAIN) ?></td>
								<td><?php _e('Shortcode', WS_TEXTDOMAIN) ?></td>
								<td><?php _e('Created', WS_TEXTDOMAIN) ?></td>
								<td><?php _e('Modified', WS_TEXTDOMAIN) ?></td>
								<td></td>
							</tr>
						</thead>
						<tbody>
							<?php if(!empty($sliders)) : ?>
							<?php foreach($sliders as $key => $val) : ?>
							<?php $name = empty($val['title']) ? 'Unnamed' : $val['title']; ?>
							<tr>
								<td><?php echo ($key+1) ?></td>
								<td><a href="?page=weatherslider&action=edit&id=<?php echo $key ?>"><?php echo $name ?></a></td>
								<td><input type="text" class="ws-shortcode" value="[weatherslider id=&quot;<?php echo !empty($val['slug']) ? $val['slug'] : ($key+1) ?>&quot;]" readonly></td>
								<td><?php echo !empty($val['date_c']) ? date('d/m/y', $val['date_c']) : 'N/A' ?></td>
								<td><?php echo !empty($val['date_m']) ? human_time_diff($val['date_m']) .' '. __('ago', WS_TEXTDOMAIN) : 'N/A' ?></td>
								<td>
									<a href="?page=weatherslider&action=duplicate&id=<?php echo $key ?>">
										<span class="dashicons dashicons-admin-page"></span>
									</a>
									<a href="?page=weatherslider&action=remove&id=<?php echo $key ?>" class="remove">
										<span class="dashicons dashicons-trash"></span>
									</a>
								</td>
							</tr>
							<?php endforeach; ?>
							<?php endif; ?>
							<?php if(empty($sliders)) : ?>
							<tr>
								<td colspan="5"><?php _e('You haven\'t created any slider yet. Click on the "Add New" button above to add one.', WS_TEXTDOMAIN) ?></td>
							</tr>
							<?php endif; ?>
						</tbody>
					</table>
				</div>
				<!-- End of slider list -->


				<!-- Plugin settings -->
				<div class="ws-box ws-settings">
					<h3 class="header medium"><?php _e('Plugin Settings', WS_TEXTDOMAIN) ?></h3>
					<table>
						<thead>
							<tr>
								<th colspan="3">
									<?php _e('Weather API', WS_TEXTDOMAIN) ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<tr<?php echo empty($api_key) ? ' class="ws-highlight"' :''  ?>>
								<td><?php _e('WWO API key', WS_TEXTDOMAIN) ?></td>
								<td><input type="text" name="weatherslider-apikey" id="ws-api-key" value="<?php echo $api_key ?>" <?php echo empty($api_key) ? 'style="border: 1px solid #C00;"' :''  ?>></td>
								<td class="desc" <?php echo empty($api_key) ? 'style="color: #444;"' :''  ?>><?php _e("Enter your API key by signing up for WWO's free service on ", WS_TEXTDOMAIN) ?> <a href="http://developer.worldweatheronline.com/signup.aspx" target="_blank">http://developer.worldweatheronline.com/signup.aspx</a>.</td>
							</tr>
							<tr>
								<td><?php _e('API version', WS_TEXTDOMAIN) ?></td>
								<td>
									<select name="weatherslider-api-version">
										<option value="1" <?php echo ($api_version == '1') ? 'selected="selected"' : '' ?>>API v1 (Premium)</option>
										<option value="2" <?php echo ($api_version == '2') ? 'selected="selected"' : '' ?>>API v2 (Free)</option>
										<option value="3" <?php echo ($api_version == '3') ? 'selected="selected"' : '' ?>>API v3 (N/A yet)</option>
									</select>
								</td>
								<td class="desc"><?php _e("Free API keys registered before November 2014 requires setting the v1 API version.", WS_TEXTDOMAIN) ?> </td>
							</tr>
							<tr>
								<td><?php _e('Use premium API', WS_TEXTDOMAIN) ?></td>
								<td><input type="checkbox" name="weatherslider-premium-api" <?php echo !empty($premium_api) ? 'checked="checked"' : '' ?>></td>
								<td class="desc"><?php _e("Enable this option if you've entered a premium API key.", WS_TEXTDOMAIN) ?> </td>
							</tr>
							<tr>
								<td><?php _e('Use HTTPS', WS_TEXTDOMAIN) ?></td>
								<td><input type="checkbox" name="weatherslider-ssl-support" <?php echo !empty($ssl_support) ? 'checked="checked"' : '' ?>></td>
								<td class="desc"><?php _e("Enable this option if your site uses SSL/TLS encryption.", WS_TEXTDOMAIN) ?> </td>
							</tr>
						</tbody>
						<thead>
							<tr>
								<th colspan="3">
									<?php _e('Caching', WS_TEXTDOMAIN) ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php _e('Enable caching', WS_TEXTDOMAIN) ?></td>
								<td><input type="checkbox" name="weatherslider-caching-support" <?php echo $cache_class ?><?php echo ($caching_support != '') ? 'checked="checked"' : '' ?>></td>
								<td class="desc"><?php _e("Caching can drastically decreases the API usage and it gives you faster response times. We're recommending to enable this option if you have a site with large traffic.", WS_TEXTDOMAIN) ?></td>
							</tr>
							<tr class="cache_hidebel">
								<td><?php _e('Cache update interval', WS_TEXTDOMAIN) ?></td>
								<td><input type="number" min="0" name="weatherslider-caching-update-interval" value="<?php echo $cache_interval ?>"></td>
								<td class="desc"><?php _e('The plugin will update weather informations in the given amount of minutes.', WS_TEXTDOMAIN) ?></td>
							</tr>
						</tbody>
						<thead>
							<tr>
								<th colspan="3">
									<?php _e('Other', WS_TEXTDOMAIN) ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php _e('Allow plugin access to') ?></td>
								<td>
									<select name="weatherslider-custom-capability">
										<?php if(is_multisite()) : ?>
										<option value="manage_network" <?php echo ($custom_capability == 'manage_network') ? 'selected="selected"' : '' ?>> <?php _e('Super Admins', WS_TEXTDOMAIN) ?></option>
										<?php endif; ?>
										<option value="manage_options" <?php echo ($custom_capability == 'manage_options') ? 'selected="selected"' : '' ?>> <?php _e('Admins', WS_TEXTDOMAIN) ?></option>
										<option value="publish_pages" <?php echo ($custom_capability == 'publish_pages') ? 'selected="selected"' : '' ?>> <?php _e('Editors, Admins', WS_TEXTDOMAIN) ?></option>
										<option value="publish_posts" <?php echo ($custom_capability == 'publish_posts') ? 'selected="selected"' : '' ?>> <?php _e('Authors, Editors, Admins', WS_TEXTDOMAIN) ?></option>
										<option value="edit_posts" <?php echo ($custom_capability == 'edit_posts') ? 'selected="selected"' : '' ?>> <?php _e('Contributors, Authors, Editors, Admins', WS_TEXTDOMAIN) ?></option>
									</select>
								</td>
								<td class="desc"><?php _e('You can allow non-administrator users to access and manage your WeatherSlider sliders.', WS_TEXTDOMAIN) ?></td>
							</tr>
						</tbody>
					</table>
				</div>


				<div class="ws-box ws-settings ws-advanced-settings collapsed">
					<h3 class="header medium">
						<?php _e('Troubleshooting & Advanced Settings', WS_TEXTDOMAIN) ?>
						<figure><span>|</span><?php _e("Don't change these settings without experience. WeatherSlider will let you know when it encounters a problem.", WS_TEXTDOMAIN) ?></figure>
						<span id="ws-advanced-settings-toggle" class="dashicons dashicons-arrow-right ws-ficon ws-box-toggle"></span>
					</h3>
					<div class="inner">
						<table>
							<tbody>
								<tr>
									<td><?php _e('Use Google CDN version of jQuery', WS_TEXTDOMAIN) ?></td>
									<td><input type="checkbox" name="ws_use_custom_jquery" <?php echo get_option('ws_use_custom_jquery', false) ? 'checked="checked"' : '' ?>></td>
									<td class="desc"><?php _e('This option will likely solve "Old jQuery" issues.', WS_TEXTDOMAIN) ?></td>
								</tr>
								<tr>
									<td><?php _e("Include scripts in the footer", WS_TEXTDOMAIN) ?></td>
									<td><input type="checkbox" name="ws_include_at_footer" <?php echo get_option('ws_include_at_footer', false) ? 'checked="checked"' : '' ?>></td>
									<td class="desc"><?php _e("Including resources in the footer could decrease load times, and solve other type of issues, but your theme might not support this method.", WS_TEXTDOMAIN) ?></td>
								</tr>
								<tr>
									<td><?php _e("Conditional script loading", WS_TEXTDOMAIN) ?></td>
									<td><input type="checkbox" name="ws_conditional_script_loading" <?php echo get_option('ws_conditional_script_loading', false) ? 'checked="checked"' : '' ?>></td>
									<td class="desc"><?php _e("Increase your site's performance by loading resources only when needed. Outdated themes might not support this method.", WS_TEXTDOMAIN) ?></td>
								</tr>
								<tr>
									<td><?php _e('Concatenate output', WS_TEXTDOMAIN) ?></td>
									<td><input type="checkbox" name="ws_concatenate_output" <?php echo get_option('ws_concatenate_output', true) ? 'checked="checked"' : '' ?>></td>
									<td class="desc"><?php _e("Concatenating the plugin's output could solve issues caused by custom filters your theme might use.", WS_TEXTDOMAIN) ?></td>
								</tr>
								<tr>
									<td><?php _e('Put JS includes to body', WS_TEXTDOMAIN) ?></td>
									<td><input type="checkbox" name="ws_put_js_to_body" <?php echo get_option('ws_put_js_to_body', false) ? 'checked="checked"' : '' ?>></td>
									<td class="desc"><?php _e('This is the most common workaround for jQuery related issues, and is recommended when you experience problems with jQuery.', WS_TEXTDOMAIN) ?></td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<!-- End of plugin settings -->

				<div class="ws-publish">
					<button class="button button-primary button-hero"><?php _e('Save changes', WS_TEXTDOMAIN) ?></button>
				</div>

			</div>

			<!-- Language -->
			<div class="ws-page">

				<!-- Language support -->
				<div class="ws-box ws-settings ws-language">
					<h3 class="header medium"><?php _e('Language Settings', WS_TEXTDOMAIN) ?></h3>
					<div class="inner">
						<?php _e('Note: You can translate WeatherSlider WP to multiple languages as well, these fields are shortcode aware, so you can use translation plugins like qTranslate. You can also use WPML\'s String Translation module. See the Help menu on the top right corner of the page for more details.', WS_TEXTDOMAIN) ?>
					</div>
					<table>
						<thead>
							<tr>
								<td colspan="3" class="topborder">
									<span class="dashicons dashicons-translation"></span>
									<h4><?php _e('Settings', WS_TEXTDOMAIN) ?></h4>
								</td>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php _e('Enable language support', WS_TEXTDOMAIN) ?></td>
								<td><input type="checkbox" name="weatherslider-language-support" <?php echo ($lang_support != '') ? 'checked="checked"' : '' ?>></td>
							</tr>
						</tbody>
						<thead class="hideable">
							<tr>
								<td colspan="3">
									<span class="dashicons dashicons-clock"></span>
									<h4><?php _e('Time & Date', WS_TEXTDOMAIN) ?></h4>
								</td>
							</tr>
						</thead>
						<tbody class="hideable">
							<tr>
								<td><?php _e('AM', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[am]" value="<?php echo isset($lang['am']) ? $lang['am'] : 'AM' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('PM', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[pm]" value="<?php echo isset($lang['pm']) ? $lang['pm'] : 'PM' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Days', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[day]" value="<?php echo isset($lang['day']) ? $lang['day'] : 'Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday' ?>"></td>
							</tr>
						</tbody>
						<thead class="hideable">
							<tr>
								<td colspan="3">
									<span class="dashicons dashicons-location"></span>
									<h4><?php _e('Location', WS_TEXTDOMAIN) ?></h4>
								</td>
							</tr>
						</thead>
						<tbody class="hideable">
							<tr>
								<td><?php _e('Current Location', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[cl]" value="<?php echo isset($lang['cl']) ? $lang['cl'] : 'Current Location' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Getting weather', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[get]" value="<?php echo isset($lang['get']) ? $lang['get'] : 'getting weather' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Location not found', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[not]" value="<?php echo isset($lang['not']) ? $lang['not'] : 'Location not found' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Unable to determine your Current Location.', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[una]" value="<?php echo isset($lang['una']) ? $lang['una'] : 'Unable to determine your Current Location.' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Enter your custom location', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[search]" value="<?php echo isset($lang['search']) ? $lang['search'] : 'Enter your custom location' ?>"></td>
							</tr>
						</tbody>
						<thead class="hideable">
							<tr>
								<td colspan="3">
									<span class="dashicons dashicons-performance"></span>
									<h4><?php _e('Condition details', WS_TEXTDOMAIN) ?></h4>
								</td>
							</tr>
						</thead>
						<tbody class="hideable">
							<tr>
								<td><?php _e('High', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[ht]" value="<?php echo isset($lang['ht']) ? $lang['ht'] : 'High' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Low', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[lt]" value="<?php echo isset($lang['lt']) ? $lang['lt'] : 'Low' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Humidity', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[hu]" value="<?php echo isset($lang['hu']) ? $lang['hu'] : 'Humidity' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Precipitation', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[pr]" value="<?php echo isset($lang['pr']) ? $lang['pr'] : 'Precipitation' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Wind', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[wi]" value="<?php echo isset($lang['wi']) ? $lang['wi'] : 'Wind' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Pressure', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[ps]" value="<?php echo isset($lang['ps']) ? $lang['ps'] : 'Pressure' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Visibility', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[vi]" value="<?php echo isset($lang['vi']) ? $lang['vi'] : 'Visibility' ?>"></td>
							</tr>
						</tbody>
						<thead class="hideable">
							<tr>
								<td colspan="3">
									<span class="dashicons dashicons-cloud"></span>
									<h4><?php _e('Condition types', WS_TEXTDOMAIN) ?></h4>
								</td>
							</tr>
						</thead>
						<tbody class="hideable">
							<tr>
								<td><?php _e('Sunny, Clear', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_113]" value="<?php echo isset($lang['c_113']) ? $lang['c_113'] : 'Sunny, Clear' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Sunny', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_114]" value="<?php echo isset($lang['c_114']) ? $lang['c_114'] : 'Sunny' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Clear', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_115]" value="<?php echo isset($lang['c_115']) ? $lang['c_115'] : 'Clear' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Partly Cloudy', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_116]" value="<?php echo isset($lang['c_116']) ? $lang['c_116'] : 'Partly Cloudy' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Cloudy', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_119]" value="<?php echo isset($lang['c_119']) ? $lang['c_119'] : 'Cloudy' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Overcast', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_122]" value="<?php echo isset($lang['c_122']) ? $lang['c_122'] : 'Overcast' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Mist', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_143]" value="<?php echo isset($lang['c_143']) ? $lang['c_143'] : 'Mist' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy rain nearby', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_176]" value="<?php echo isset($lang['c_176']) ? $lang['c_176'] : 'Patchy rain nearby' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy snow nearby', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_179]" value="<?php echo isset($lang['c_179']) ? $lang['c_179'] : 'Patchy snow nearby' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy sleet nearby', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_182]" value="<?php echo isset($lang['c_182']) ? $lang['c_182'] : 'Patchy sleet nearby' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy freezing drizzle nearby', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_185]" value="<?php echo isset($lang['c_185']) ? $lang['c_185'] : 'Patchy freezing drizzle nearby' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Thundery outbreaks in nearby', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_200]" value="<?php echo isset($lang['c_200']) ? $lang['c_200'] : 'Thundery outbreaks in nearby' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Blowing snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_227]" value="<?php echo isset($lang['c_227']) ? $lang['c_227'] : 'Blowing snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Blizzard', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_230]" value="<?php echo isset($lang['c_230']) ? $lang['c_230'] : 'Blizzard' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Fog', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_248]" value="<?php echo isset($lang['c_248']) ? $lang['c_248'] : 'Fog' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Freezing fog', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_260]" value="<?php echo isset($lang['c_260']) ? $lang['c_260'] : 'Freezing fog' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy light drizzle', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_263]" value="<?php echo isset($lang['c_263']) ? $lang['c_263'] : 'Patchy light drizzle' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light drizzle', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_266]" value="<?php echo isset($lang['c_266']) ? $lang['c_266'] : 'Light drizzle' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Freezing drizzle', WS_TEXTDOMAIN) ?></td>
								<td  class="last"><input type="text"name="lang[c_281]" value="<?php echo isset($lang['c_281']) ? $lang['c_281'] : 'Freezing drizzlee' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Heavy freezing drizzle', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_284]" value="<?php echo isset($lang['c_284']) ? $lang['c_284'] : 'Heavy freezing drizzle' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy light rain', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_293]" value="<?php echo isset($lang['c_293']) ? $lang['c_293'] : 'Patchy light rain' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light rain', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_296]" value="<?php echo isset($lang['c_296']) ? $lang['c_296'] : 'Light rain' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate rain at times', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_299]" value="<?php echo isset($lang['c_299']) ? $lang['c_299'] : 'Moderate rain at times' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate rain', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_302]" value="<?php echo isset($lang['c_302']) ? $lang['c_302'] : 'Moderate rain' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Heavy rain at times', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_305]" value="<?php echo isset($lang['c_305']) ? $lang['c_305'] : 'Heavy rain at times' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Heavy rain', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_308]" value="<?php echo isset($lang['c_308']) ? $lang['c_308'] : 'Heavy rain' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light freezing rain', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_311]" value="<?php echo isset($lang['c_311']) ? $lang['c_311'] : 'Light freezing rain' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or Heavy freezing rain', WS_TEXTDOMAIN) ?></td>
								<td  class="last"><input type="text"name="lang[c_314]" value="<?php echo isset($lang['c_314']) ? $lang['c_314'] : 'Moderate or Heavy freezing rain' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light sleet', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_317]" value="<?php echo isset($lang['c_317']) ? $lang['c_317'] : 'Light sleet' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy sleet', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_320]" value="<?php echo isset($lang['c_320']) ? $lang['c_320'] : 'Moderate or heavy sleet' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy light snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_323]" value="<?php echo isset($lang['c_323']) ? $lang['c_323'] : 'Patchy light snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_326]" value="<?php echo isset($lang['c_326']) ? $lang['c_326'] : 'Light snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy moderate snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_329]" value="<?php echo isset($lang['c_329']) ? $lang['c_329'] : 'Patchy moderate snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_332]" value="<?php echo isset($lang['c_332']) ? $lang['c_332'] : 'Moderate snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy heavy snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_335]" value="<?php echo isset($lang['c_335']) ? $lang['c_335'] : 'Patchy heavy snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Heavy snow', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_338]" value="<?php echo isset($lang['c_338']) ? $lang['c_338'] : 'Heavy snow' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Ice pellets', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_350]" value="<?php echo isset($lang['c_350']) ? $lang['c_350'] : 'Ice pellets' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light rain shower', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_353]" value="<?php echo isset($lang['c_353']) ? $lang['c_353'] : 'Light rain shower' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy rain shower', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_356]" value="<?php echo isset($lang['c_356']) ? $lang['c_356'] : 'Moderate or heavy rain shower' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Torrential rain shower', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_359]" value="<?php echo isset($lang['c_359']) ? $lang['c_359'] : 'Torrential rain shower' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light sleet showers', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_362]" value="<?php echo isset($lang['c_362']) ? $lang['c_362'] : 'Light sleet showers' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy sleet showers', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_365]" value="<?php echo isset($lang['c_365']) ? $lang['c_365'] : 'Moderate or heavy sleet showers' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light snow showers', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_368]" value="<?php echo isset($lang['c_368']) ? $lang['c_368'] : 'Light snow showers' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy snow showers', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_371]" value="<?php echo isset($lang['c_371']) ? $lang['c_371'] : 'Moderate or heavy snow showers' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Light showers of ice pellets', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_374]" value="<?php echo isset($lang['c_374']) ? $lang['c_374'] : 'Light showers of ice pellets' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy showers of ice pellets', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_377]" value="<?php echo isset($lang['c_377']) ? $lang['c_377'] : 'Moderate or heavy showers of ice pellets' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy light rain in area with thunder', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_386]" value="<?php echo isset($lang['c_386']) ? $lang['c_386'] : 'Patchy light rain in area with thunder' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy rain in area with thunder', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_389]" value="<?php echo isset($lang['c_389']) ? $lang['c_389'] : 'Moderate or heavy rain in area with thunder' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Patchy light snow in area with thunder', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_392]" value="<?php echo isset($lang['c_392']) ? $lang['c_392'] : 'Patchy light snow in area with thunder' ?>"></td>
							</tr>
							<tr>
								<td><?php _e('Moderate or heavy snow in area with thunder', WS_TEXTDOMAIN) ?></td>
								<td class="last"><input type="text"name="lang[c_395]" value="<?php echo isset($lang['c_395']) ? $lang['c_395'] : 'Moderate or heavy snow in area with thunder' ?>"></td>
							</tr>
						</tbody>
					</table>
				</div>
				<!-- End of language support -->

				<div class="ws-publish">
					<button class="button button-primary button-hero"><?php _e('Save changes', WS_TEXTDOMAIN) ?></button>
				</div>
			</div>
		</form>

		<!-- News & Updates -->
		<div class="ws-page">

			<!-- Auto-update -->
			<?php if($GLOBALS['wsAutoUpdateBox'] == true) : ?>
			<form action="<?php echo $_SERVER['REQUEST_URI'] ?>" method="post" class="ws-box ws-auto-update">
				<input type="hidden" name="action" value="weatherslider_verify_purchase_code">
				<h3 class="header medium">
					<?php _e('Auto-updates', WS_TEXTDOMAIN) ?>
					<figure><span>|</span>Update notifications and one-click installation</figure>
				</h3>
				<table>
					<tbody>
						<tr>
							<td class="right"><?php _e('Purchase code:', WS_TEXTDOMAIN) ?></td>
							<td class="desc">
								<input type="text" class="license-key" name="purchase_code" value="<?php echo $code ?>" placeholder="e.g. bc8e2b24-3f8c-4b21-8b4b-90d57a38e3c7"><br>
							</td>
							<td class="right"><?php _e('Release channel:', WS_TEXTDOMAIN) ?></td>
							<td>
								<label><input type="radio" name="channel" value="stable" <?php echo ($channel === 'stable') ? 'checked="checked"' : ''?>> <?php _e('Stable', WS_TEXTDOMAIN) ?></label>
								<label data-help="<?php _e('Although pre-release versions should be fine, they might contain unknown issues, and are not recommended for sites in production.', WS_TEXTDOMAIN) ?>">
									<input type="radio" name="channel" value="beta" <?php echo ($channel === 'beta') ? 'checked="checked"' : ''?>> <?php _e('Beta', WS_TEXTDOMAIN) ?>
								</label>
							</td>
						</tr>
						<tr>
							<td colspan="4"><?php _e('To receive auto-updates, you need to enter your item purchase code. You can find it on your CodeCanyon downloads page, just click on the Download button and choose the "Licence Certificate" option. This will download a text file that contains your purchase code.', WS_TEXTDOMAIN) ?></td>
						</tr>
					</tbody>
					<tfoot>
						<tr>
							<td colspan="4">
								<button class="button button-primary"><?php _e('Save changes', WS_TEXTDOMAIN) ?></button>
								<span style="<?php echo ($validity == '0' && $code != '') ? 'color: #c33219;' : 'color: #4b982f'?>">
									<?php
										if($validity == '1') {
											_e('Thank you for purchasing WeatherSlider.', WS_TEXTDOMAIN);
											echo '<a href="update-core.php">', __('Check for update', WS_TEXTDOMAIN), '</a>';

										} else if($code != '') {
											_e("Your purchase code doesn't appear to be valid.", WS_TEXTDOMAIN);
										}
									?>
								</span>
							</td>
						</tr>
					</tfoot>
				</table>
			</form>
			<?php endif; ?>
			<!-- End of auto-update -->

			<!-- News -->
			<div class="ws-box ws-news">
				<div class="header medium">
					<h2><?php _e('WeatherSlider News', WS_TEXTDOMAIN) ?></h2>
					<div class="filters">
						<span><?php _e('Filter:', WS_TEXTDOMAIN) ?></span>
						<ul>
							<li class="active" data-page="all"><?php _e('All', WS_TEXTDOMAIN) ?></li>
							<li data-page="announcements"><?php _e('Announcements', WS_TEXTDOMAIN) ?></li>
							<li data-page="changes"><?php _e('Release log', WS_TEXTDOMAIN) ?></li>
							<li data-page="betas"><?php _e('Beta versions', WS_TEXTDOMAIN) ?></li>
						</ul>
					</div>
					<div class="ws-version"><?php _e('You have version', WS_TEXTDOMAIN) ?> <?php echo WS_PLUGIN_VERSION ?> <?php _e('installed', WS_TEXTDOMAIN) ?></div>
				</div>
				<div>
					<iframe src="https://news.kreaturamedia.com/weatherslider/"></iframe>
				</div>
			</div>
		</div>
		<!-- End of News -->

	</div>

</div>


<!-- Help menu WP Pointer -->
<?php

if(get_user_meta( get_current_user_id(), 'weatherslider_help_wp_pointer', true) != '1') {
add_user_meta( get_current_user_id(), 'weatherslider_help_wp_pointer', '1'); ?>
<script type="text/javascript">
	jQuery(document).ready(function() {
		jQuery('#contextual-help-link-wrap').pointer({
			pointerClass : 'ws-help-pointer',
			pointerWidth : 320,
			content: '<h3><?php _e('The documentation is here', WS_TEXTDOMAIN) ?></h3><div class="inner"><?php _e('This is a WordPress contextual help menu, we use it to give you fast access to our documentation.', WS_TEXTDOMAIN) ?> </div>',
			position: {
				edge : 'top',
				align : 'right'
			}
		}).pointer('open');
	});
</script>
<?php } ?>