<?php

/*
Plugin Name: WeatherSlider WP
Plugin URI: http://codecanyon.net/user/kreatura/?ref=kreatura
Description: This is a beautiful weather slider WordPress widget with animated weather effects and 48 weather condition types.
Version: 2.6.8
Author: Kreatura Media
Author URI: https://kreaturamedia.com/
Text Domain: WeatherSlider
*/

/********************************************************/
/*                        Actions                       */
/********************************************************/


	if(!defined('ABSPATH')) {
		header('HTTP/1.0 403 Forbidden');
		exit;
	}

	// Compatibility
	$GLOBALS['wsAutoUpdateBox'] = true;
	$GLOBALS['wsPluginSlug'] = basename(dirname(__FILE__));

	// Constants
	define('WS_ROOT_FILE', __FILE__);
	define('WS_ROOT_PATH', dirname(__FILE__));
	define('WS_ROOT_URL', plugins_url('', __FILE__));
	define('WS_PLUGIN_VERSION', '2.6.8');
	define('WS_PLUGIN_SLUG', basename(dirname(__FILE__)));
	define('WS_PLUGIN_BASE', plugin_basename(__FILE__));
	define('WS_TEXTDOMAIN', 'WeatherSlider');

	if(!defined('NL')) { define("NL", "\r\n"); }
	if(!defined('TAB')) { define("TAB", "\t"); }

	// Auto update
	if(!class_exists('KM_PluginUpdates')) {
		require_once WS_ROOT_PATH.'/classes/class.km.autoupdate.plugins.php';
	}

	if(get_option('weatherslider-validated', '0')) {
		new KM_PluginUpdates(array(
			'root' => WS_ROOT_FILE,
			'version' => WS_PLUGIN_VERSION,
			'repo' => 'https://updates.kreaturamedia.com/plugins/',
			'channel' => get_option('weatherslider-release-channel', 'stable'),
			'license' => get_option('weatherslider-purchase-code', '')
		));
	}

	// Update notice
	if(strpos($_SERVER['REQUEST_URI'], '?page=weatherslider') !== false) {
		add_action('admin_notices', 'weatherslider_update_notice');
	}

	// Register custom settings menu
	add_action('admin_menu', 'weatherslider_settings_menu');

	// Link content resources
	add_action('wp_enqueue_scripts', 'weatherslider_enqueue_content_res');

	// Link admin resources
	add_action('admin_enqueue_scripts', 'weatherslider_enqueue_admin_res');

	// Add shortcode
	add_shortcode('weatherslider', 'weatherslider_init');

	// Widget action
	add_action( 'widgets_init', create_function( '', 'register_widget("WeatherSlider_Widget");' ) );

	// Load plugin locale
	add_action('plugins_loaded', 'weatherslider_load_lang');

	// WWO API Key notice
	if(get_option('weatherslider-apikey') == '') {

		// Get current page
		global $pagenow;

		// Plugins page
		if($pagenow == 'plugins.php' || $pagenow == 'index.php' || strpos($_SERVER['REQUEST_URI'], '?page=weatherslider') !== false) {
			add_action('admin_notices', 'weatherslider_admin_notice');
		}
	}

	// Help menu
	add_filter('contextual_help', 'weatherslider_help', 10, 3);

	// Remove slider
	if(isset($_GET['page']) && $_GET['page'] == 'weatherslider' && isset($_GET['action']) && $_GET['action'] == 'remove') {
		weatherslider_removeslider( $_GET['id'] );
	}

	// Duplicate slider
	if(isset($_GET['page']) && $_GET['page'] == 'weatherslider' && isset($_GET['action']) && $_GET['action'] == 'duplicate') {
		weatherslider_duplicateslider( $_GET['id'] );
	}

	// AJAXs
	add_action('wp_ajax_weatherslider_getdata', 'weatherslider_getdata');
	add_action('wp_ajax_nopriv_weatherslider_getdata', 'weatherslider_getdata');




/********************************************************/
/*                 Check purchase code                  */
/********************************************************/
add_action('wp_ajax_weatherslider_verify_purchase_code', 'weatherslider_verify_purchase_code');
function weatherslider_verify_purchase_code() {

	global $wp_version;

	// Get data
	$code = trim($_POST['purchase_code']);
	$oldCode = get_option('weatherslider-purchase-code', '');
	$validated = get_option('weatherslider-validated', '0');
	$channel = ($_POST['channel'] === 'beta') ? 'beta' : 'stable';

	// Save release channel
	update_option('weatherslider-release-channel', $channel);

	// Release channel
	if($validated == 1) {
		if(!preg_match('/^[a-z0-9]+$/i', $code[0]) || $oldCode == $code) {
			die(json_encode(array('success' => true, 'message' => __('Your settings were successfully saved.', WS_TEXTDOMAIN) . '<a href="update-core.php">' . __('Check for update', WS_TEXTDOMAIN) . '</a>' )));
		}
	}

	// Save purchase code
	update_option('weatherslider-purchase-code', $code);

	// Verify license
	$response = wp_remote_post('https://activate.kreaturamedia.com/', array(
		'user-agent' => 'WordPress/'.$wp_version.'; '.get_bloginfo('url'),
		'body' => array(
			'plugin' => urlencode('WeatherSlider'),
			'license' => urlencode($code)
		)
	));


	if($response['body'] == 'valid') {
		update_option('weatherslider-validated', '1');
		die(json_encode(array('success' => true, 'message' => __('Thank you for purchasing WeatherSlider.', WS_TEXTDOMAIN) . '<a href="update-core.php">' . __('Check for update', WS_TEXTDOMAIN) . '</a>')));

	// Invalid
	} else {
		update_option('weatherslider-validated', '0');
		die(json_encode(array('success' => false, 'message' => __("Your purchase code doesn't appear to be valid.", WS_TEXTDOMAIN))));
	}
}

/********************************************************/
/*                 WeatherSlider locale                 */
/********************************************************/
function weatherslider_load_lang() {
	load_plugin_textdomain('WeatherSlider', false, WS_PLUGIN_SLUG . '/locales/' );
}

/********************************************************/
/*               Enqueue Content Scripts                */
/********************************************************/

	function weatherslider_enqueue_content_res() {


		// Include in the footer?
		$footer = get_option('ws_include_at_footer', false) ? true : false;

		// Use Gogole CDN version of jQuery
		if(get_option('ws_use_custom_jquery', false)) {
			wp_deregister_script('jquery');
			wp_enqueue_script('jquery', '//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js', false, '1.8.3');
		}

		wp_register_script('google-maps', 'https://maps.googleapis.com/maps/api/js?sensor=false&language=en', false, '3' );
		wp_register_script('background_position', plugins_url('/js/jquery-animate-background-position.js', __FILE__), array('jquery'), WS_PLUGIN_VERSION, $footer );
		wp_register_script('jquery_easing', plugins_url('/js/jquery-easing-1.3.js', __FILE__), array('jquery'), '1.3.0', $footer );
		wp_register_script('weatherslider_js', plugins_url('/js/weatherslider.kreaturamedia.jquery.js', __FILE__), array('jquery'), WS_PLUGIN_VERSION, $footer );
		wp_enqueue_style('weatherslider_css', plugins_url('/css/weatherslider.css', __FILE__), false, WS_PLUGIN_VERSION );

		if(get_option('ws_conditional_script_loading', false) == false) {
			wp_enqueue_script('google-maps');
			wp_enqueue_script('background_position');
			wp_enqueue_script('jquery_easing');
			wp_enqueue_script('weatherslider_js');
		}
	}


/********************************************************/
/*                Enqueue Admin Scripts                 */
/********************************************************/

	function weatherslider_enqueue_admin_res() {

		// Get current page
		global $pagenow;

		// Global
		wp_enqueue_style('weatherslider_global_css', plugins_url('/css/global.css', __FILE__), false, WS_PLUGIN_VERSION );

		// Use Gogole CDN version of jQuery
		if(get_option('ws_use_custom_jquery', false)) {
			wp_deregister_script('jquery');
			wp_enqueue_script('jquery', '//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js', false, '1.8.3');
		}


		// WeatherSlider page
		if(strstr($_SERVER['REQUEST_URI'], 'weatherslider')) {

			wp_enqueue_script('wp-pointer');
			wp_enqueue_style('wp-pointer');

			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('google_maps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyC_iL-1h1jz_StV_vMbVtVfh3h2QjVUZ8c&sensor=false&language=en', false, '3.0' );
			wp_enqueue_script('weatherslider_admin_js', plugins_url('/js/admin.js', __FILE__), array('jquery'), WS_PLUGIN_VERSION );
			wp_enqueue_style('weatherslider_admin_css', plugins_url('/css/admin.css', __FILE__), false, WS_PLUGIN_VERSION );

			// Dashicons
			if(version_compare(get_bloginfo('version'), '3.8', '<')) {
				wp_enqueue_style('dashicons', plugins_url('/css/dashicons.css', __FILE__), false, WS_PLUGIN_VERSION );
			}
		}
	}

/********************************************************/
/*                 Loads settings menu                  */
/********************************************************/
function weatherslider_settings_menu() {

	// Menu hook
	global $weatherslider_hook;

	$capability = get_option('weatherslider-custom-capability', 'manage_options');
	$icon = version_compare(get_bloginfo('version'), '3.8', '>=') ? 'dashicons-cloud' : plugins_url('/img/icon_16x16.png', __FILE__);

	// Create new top-level menu
	$weatherslider_hook = add_menu_page('WeatherSlider WP', 'WeatherSlider WP', $capability, 'weatherslider', 'weatherslider_settings_page_router', $icon);

	// Call register settings function
	add_action( 'admin_init', 'weatherslider_register_settings' );
}

/********************************************************/
/*                    Settings page                     */
/********************************************************/
function weatherslider_settings_page_router() {


	if(isset($_GET['action']) && $_GET['action'] == 'add') {
		include(WS_ROOT_PATH.'/add.php');

	} else if(isset($_GET['action']) && $_GET['action'] == 'edit') {
		include(WS_ROOT_PATH.'/edit.php');

	} else {
		include(WS_ROOT_PATH.'/list.php');
	}
}

/********************************************************/
/*                  Register settings                   */
/********************************************************/
function weatherslider_register_settings() {
	if(current_user_can(get_option('weatherslider-custom-capability', 'manage_options'))) {

		// Global settings
		if(isset($_POST['ws_posted_global'])) {
			if(check_admin_referer('ws-save-globals')) {

				$checkboxes = array(
					'weatherslider-premium-api', 'weatherslider-ssl-support',
					'weatherslider-caching-support', 'weatherslider-language-support',
					'ws_use_custom_jquery', 'ws_include_at_footer',
					'ws_conditional_script_loading', 'ws_concatenate_output',
					'ws_put_js_to_body'
				);

				foreach($checkboxes as $item) {
					update_option($item, array_key_exists($item, $_POST));
				}

				// Update values
				update_option('weatherslider-apikey', $_POST['weatherslider-apikey']);
				update_option('weatherslider-api-version', $_POST['weatherslider-api-version']);
				update_option('weatherslider-caching-update-interval', $_POST['weatherslider-caching-update-interval']);
				update_option('weatherslider-custom-capability', $_POST['weatherslider-custom-capability']);
				update_option('weatherslider-lang-strings', json_encode($_POST['lang']));

				// WPML
				if(function_exists('icl_register_string')) {
					if(!empty($_POST['lang']) && is_array($_POST['lang'])) {
						foreach($_POST['lang'] as $key => $val) {
							icl_register_string('WeatherSlider WP', $key, $val);
						}
					}
				}

				// Redirect
				header('Location: '.$_SERVER['REQUEST_URI'].'');
				die();
			}

		// Add
		} else if(isset($_POST['ws_posted_add'])) {
			if(check_admin_referer('ws-add-slider')) {

				$id = weatherslider_addslider( $_POST['title'] );
				header('Location: admin.php?page=weatherslider&action=edit&id='.$id.'');
				die();
			}

		// Edit
		} else if(isset($_POST['ws_posted_edit'])) {
			if(check_admin_referer('ws-edit-slider')) {

				$key = (int) $_POST['sliderkey'];
				weatherslider_editslider( $key, $_POST['slider_data']);
				header('Location: admin.php?page=weatherslider&action=edit&id='.$key.'');
				die();
			}
		}
	}
}



/********************************************************/
/*                     Add slider                    */
/********************************************************/
function weatherslider_addslider($title = '') {

	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Add new slider
	$time = time();
	$sliders[] = array('title' => $title, 'date_c' => $time, 'date_m' => $time);

	// Update sliders
	update_option('weatherslider-sliders', json_encode($sliders));

	// Return new ID
	$items = array_keys($sliders);
	return end($items);
}


/********************************************************/
/*                     Edit slider                    */
/********************************************************/
function weatherslider_editslider($id = 0, $data = array()) {

	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Update slider
	$sliders[$id] = $data;

	// Update sliders
	update_option('weatherslider-sliders', json_encode($sliders));
}


/********************************************************/
/*                     Remove slider                    */
/********************************************************/
function weatherslider_removeslider($key) {

	$key = (int) $key;

	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Remove the slider
	array_splice($sliders, $key, 1);

	// Update settings
	update_option('weatherslider-sliders', json_encode($sliders));

	// Success
	header('Location: admin.php?page=weatherslider');
	die();

}


/********************************************************/
/*                    Duplicate slider                  */
/********************************************************/
function weatherslider_duplicateslider($key) {

	$key = (int) $key;

	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Get slider
	$slider = $sliders[ $key ];

	// Name check
	if(empty($slider['title'])) {
		$slider['title'] = 'Unnamed';
	}

	// Rename
	$slider['title'] .= ' copy';

	// Append duplicate
	$sliders[] = $slider;

	// Update settings
	update_option('weatherslider-sliders', json_encode($sliders));

	// Success
	header('Location: admin.php?page=weatherslider');
	die();
}

/********************************************************/
/*                      Help menu                       */
/********************************************************/
function weatherslider_help($contextual_help, $screen_id, $screen) {

	global $weatherslider_hook;
	if ($screen_id == $weatherslider_hook) {
		$screen = get_current_screen();

		$screen->add_help_tab(array(
			'id' => 'help',
			'title' => 'Getting Help',
			'content' => '<p>Please read our  <a href="https://support.kreaturamedia.com/docs/weathersliderwp/documentation.html" target="_blank">Online Documentation</a> carefully, it will likely answer all of your questions.</p><p>You can also check the <a href="https://support.kreaturamedia.com/faq/3/weatherslider-for-wordpress/" target="_blank">FAQs</a> for additional information, including our support policies and licensing rules.</p>'
		));
	}
}

/********************************************************/
/*               WWO API Key admin notice               */
/********************************************************/
function weatherslider_admin_notice() {
	?>
	<div class="ws-notice">
		<img src="<?php echo WS_ROOT_URL.'/img/ws_80x80.png' ?>" alt="WeatherSlider icon">
		<h1><?php _e('WeatherSlider WP is almost ready!', WS_TEXTDOMAIN) ?></h1>
		<p>
			<?php _e('WeatherSlider WP requires a Word Weather Online API key! Please navigate to WeatherSlider WP', WS_TEXTDOMAIN) ?>
			<a href="admin.php?page=weatherslider"><?php _e('settings page', WS_TEXTDOMAIN) ?></a>
			<?php _e('and enter your own API key. You can register and get your FREE API key', WS_TEXTDOMAIN) ?> <a target="_blank" href="http://developer.worldweatheronline.com/signup.aspx"><?php _e('from here', WS_TEXTDOMAIN) ?></a>.
		</p>
		<div class="clear"></div>
	</div>
	<?php
}


function weatherslider_update_notice() {

	// Get plugin updates
	$updates = get_plugin_updates();

	// Check for update
	if(isset($updates[WS_PLUGIN_BASE]) && isset($updates[WS_PLUGIN_BASE]->update)) {
		$update = $updates[WS_PLUGIN_BASE];
		add_thickbox();
		?>
		<div class="ws-notice">
			<img src="<?php echo WS_ROOT_URL.'/img/ws_80x80.png' ?>" alt="WeatherSlider icon">
			<h1><?php _e('Update available for WeatherSlider!', WS_TEXTDOMAIN) ?></h1>
			<p>
				<?php echo sprintf(__('You have version %1$s. Update to version %2$s.', WS_TEXTDOMAIN), $update->Version, $update->update->new_version); ?><br>
				<i><?php echo $update->update->upgrade_notice ?></i>
				<a href="plugin-install.php?tab=plugin-information&plugin=WeatherSlider&section=changelog&TB_iframe=true&width=640&height=747" class="thickbox ws-button">
					<?php _e('Review changes & Install', WS_TEXTDOMAIN) ?>
				</a>
			</p>
			<div class="clear"></div>
		</div>
		<?php
	}
}

/********************************************************/
/*             WeatherSlider WP shortcode               */
/********************************************************/
function weatherslider_init($atts, $content = null) {

	if(isset($atts['location'])) {
		return '[WeatherSlider] Invalid shortcode';
	}

	if(empty($atts['id'])) {
		return '[WeatherSlider] Invalid slider';
	}

	// Get slider ID
	$id = $atts['id'];
	$id = empty($id) ? 1 : (int) $id;

	// Get sliders
	$sliders = get_option('weatherslider-sliders');
	$sliders = !empty($sliders) ? json_decode($sliders, true) : array();

	// Get slider
	if(is_numeric($id) && isset($sliders[($id-1)])) {
		$slider = $sliders[($id-1)];
	} else {
		foreach($sliders as $item) {
			if(isset($item['slug']) && $item['slug'] == $id) {
				$slider = $item;
				break;
			}
		}
	}

	if(!isset($slider)) {
		return '[WeatherSlider] Slider not found';
	}

	// Return data
	$ret = '';

	if(!defined('NL')) {
		define("NL", "\r\n");
	}

	if(!defined('TAB')) {
		define("TAB", "\t");
	}

	// Get init code
	include(WS_ROOT_PATH.'/init.php');

	// Code to return
	$ret .= '<div id="weatherslider_'.$id.'" style="width:'.$slider['width'].'px;height:'.$slider['height'].'px;">';
	if(isset($slider['locations']) && !empty($slider['locations'])) {
		foreach($slider['locations'] as $key => $city) :
			$title = !empty($slider['titles'][$key]) ? ' title="'.stripslashes($slider['titles'][$key]).'"' : '';
			$ret.='<span class="ws-location"'. $title.'>'.$city.'</span>';
		endforeach;
	} else {
		$ret.='<span class="ws-location">GEOLOCATION</span>';
	}
	$ret.='</div>';

	// Return data
	if(get_option('ws_concatenate_output', true)) {
		$ret = trim(preg_replace('/\s+/u', ' ', $ret));
	}

	return $ret;
}

/********************************************************/
/*          Function to show WS with filters            */
/********************************************************/
function weatherslider($id = 0, $page = '') {

	// Check id
	if(!isset($id) || empty($id)) {
		echo '[WeatherSlider WP] You need to specify the "id" parameter for the weatherslider() function call';
		return;
	}

	// Page filter
	if(isset($page) && !empty($page)) {

		// Get page name, ID and categories
		$pagename = basename(get_permalink());
		$pageid = (string) get_the_ID();
		$categories = get_the_category();

		// Get pages
		$pages = explode(',', $page);

		// Iterate over the pages
		foreach($pages as $page) {

			if($page == 'homepage' && is_front_page()) {
				echo weatherslider_init(array('id' => $id));

			} elseif($pageid == $page) {
				echo weatherslider_init(array('id' => $id));

			} elseif($pagename == $page) {
				echo weatherslider_init(array('id' => $id));

			} elseif(in_category($page)) {
				echo weatherslider_init(array('id' => $id));
			}
		}


	// All pages
	} else {
		echo weatherslider_init(array('id' => $id));
	}
}

/********************************************************/
/*              WeatherSlider WP widget                 */
/********************************************************/
class WeatherSlider_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'weatherslider_widget', 'description' => __('Weather Widget', WS_TEXTDOMAIN) );
		$control_ops = array( 'id_base' => 'weatherslider_widget' );
		parent::__construct( 'weatherslider_widget', __('WeatherSlider Widget', WS_TEXTDOMAIN), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		// Defaults
		if(!isset($instance['title'])) {
			$instance['title'] = 'WeatherSlider';
		}

		if(!isset($instance['id'])) {
			$instance['id'] = '1';
		}

		$title = apply_filters('widget_title', $instance['title'] );

		echo $before_widget;

		if ( $title )
			echo $before_title . $title . $after_title;


		echo do_shortcode('[weatherslider id="'.$instance['id'].'"]');

		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['id'] = strip_tags( $new_instance['id'] );
		$instance['title'] = strip_tags( $new_instance['title'] );
		return $instance;
	}

	function form( $instance ) {

		// Defaults
		$defaults = array( 'title' => __('WeatherSlider', WS_TEXTDOMAIN));
		$instance = wp_parse_args( (array) $instance, $defaults );


		// Get sliders
		$sliders = get_option('weatherslider-sliders');
		$sliders = !empty($sliders) ? json_decode($sliders, true) : array();
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'id' ); ?>"><?php _e('Choose a slider:', WS_TEXTDOMAIN) ?></label><br>
			<?php if(isset($sliders) && !empty($sliders)) { ?>
			<select id="<?php echo $this->get_field_id( 'id' ); ?>" name="<?php echo $this->get_field_name( 'id' ); ?>">
				<?php foreach($sliders as $key => $val) : ?>
				<?php $name = empty($val['title']) ? 'Unnamed' : $val['title']; ?>
				<?php if(($key+1) == $instance['id']) { ?>
				<option value="<?php echo $key+1?>" selected="selected"><?php echo $name ?> | #<?php echo $key+1?></option>
				<?php } else { ?>
				<option value="<?php echo $key+1?>"><?php echo $name ?> | #<?php echo $key+1?></option>
				<?php } ?>
				<?php endforeach; ?>
			</select>
			<?php } else { ?>
			<span>Create a slider first!</span>
			<?php } ?>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', WS_TEXTDOMAIN) ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" />
		</p>

	<?php
	}
}

/********************************************************/
/*                   Caching functions                  */
/********************************************************/

function weatherslider_getdata() {

	// Get options
	$caching = get_option('weatherslider-caching-support', '');

	// Get location
	$location = $_GET['location'];

	// Get data type
	$service = (isset($_GET['service']) && $_GET['service'] == 'timezone') ? 'timezone' : 'weather';

	// Cache files
	$file = WS_ROOT_PATH.'/cache/'.base64_encode($location.'_'.$service);
	$file_weather = WS_ROOT_PATH.'/cache/'.base64_encode($location.'_weather');
	$file_timezone = WS_ROOT_PATH.'/cache/'.base64_encode($location.'_timezone');


	// Disabled caching
	if(empty($caching) || !$caching) {
		$data = weatherslider_get_weather_data($location);
		die($data[$service]);

	// Enabled caching
	} else {

		// Get cache contents
		if($data = weatherslider_getcache($file, $service)) {
			die($data);

		// No cache
		} else {

			// Get API data
			$data = weatherslider_get_weather_data($location);

			// Save them
			weatherslider_savecache($file_weather, $data['weather']);
			weatherslider_savecache($file_timezone, $data['timezone']);

			// Return it
			die($data[$service]);
		}
	}
}

function weatherslider_getcache($file, $service) {

	// Get option
	$cache_interval = get_option('weatherslider-caching-update-interval', '30');

	// Cache exists and not expired
	if(file_exists($file))  {
		if( filemtime($file) > time() - $cache_interval * 60) {

			// Get file contents
			$content = file_get_contents($file);

			// Local time fix
			if($service == 'timezone') {
				$content = json_decode($content, true);
				$offset = $content['data']['time_zone'][0]['utcOffset'];

				$localtime = time() + (60 * 60 * $offset);
				$localtime = gmdate('Y-m-d H:i', $localtime);

				$content['data']['time_zone'][0]['localtime'] = $localtime;
				$content = json_encode($content);
			}

			return $content;
		}
	}

	// Otherwise return false
	return false;
}

function weatherslider_savecache($file, $data) {
	file_put_contents($file, $data);
}

function weatherslider_get_weather_data($location) {

	// Get options
	$api_key = get_option('weatherslider-apikey', '');
	$api_version = get_option('weatherslider-api-version', '1');
	$api_type = get_option('weatherslider-premium-api', true);
	$api_type = empty($api_type) ? 'free' : 'premium';
	$ssl_support = get_option('weatherslider-ssl-support', true);
	$urlScheme = $ssl_support ? 'https' : 'http';
	$api_base_url = 'api.worldweatheronline.com';

	// Build URL for weather data
	$url = vsprintf('%s://%s/%s/v%s/weather.ashx?key=%s&format=json&q=%s&num_of_days=5', array(
		$urlScheme, $api_base_url, $api_type, $api_version, $api_key, urlencode($location),
	));


	// Make the call for weather data
	$request = wp_remote_get($url);
	$weather = wp_remote_retrieve_body($request);


	// Built URL for timezone
	$url = vsprintf('%s://%s/%s/v%s/tz.ashx?key=%s&format=json&q=%s', array(
		$urlScheme, $api_base_url, $api_type, $api_version, $api_key, urlencode($location)
	));

	// Make the call for timezome
	$request = wp_remote_get($url);
	$timezone = wp_remote_retrieve_body($request);

	// Get data
	return array('weather' => $weather, 'timezone' => $timezone);
}

?>