
/*
	* wpStickies
	*
	* (c) 2012-2014 George Krupa, John Gera & Kreatura Media
	*
	* web:					http://kreaturamedia.com/
	* Facebook: 			http://facebook.com/kreaturamedia/
	* Plugin demo:			http://wordpress.kreatura.hu/wpstickies-the-premium-image-tagging-plugin-for-wordpress/
	*
	* Licenses:
	*
	* http://codecanyon.net/licenses/
*/



(function($) {

	// wpStickies Preinit

	$.fn.wpStickies = function( options ){

		var method = arguments[0];

		if(methods[method]) {
			method = methods[method];
			arguments = Array.prototype.slice.call(arguments, 1);
		} else if( typeof(method) == 'object' || !method ) {
			method = methods.init;
		} else {
			$.error( 'Method ' +  method + ' does not exist in wpStickies!');
			return this;
		}

		return method.apply(this, arguments);
	};

	// wpStickies Methods

	var methods = {

		init : function(options) {

			// Repeat over each element in selector

			return this.each(function() {

				// Attempting to get the wpStickies data of element

				// If we cannot get data...*

				if( !$(this).data('wpStickies') ){

					// Default Options. You can change them here or by calling $(element).wpStickies({ optionName1 : optionPoperty1, optionName2 : optionProperty2 });

					var defaults = {
						settings : {
							allowToCreate		: true,
							showMessages		: true,
							allowToModify		: true,
							alwaysVisible		: true,
							imageMinWidth		: 150,
							imageMinHeight		: 100
						},
						position : {
							spotBubbleDirection	: 'top',
							autoChangeDirection	: true,
							spotBubbleDistance	: 2,
							areaMinWidth		: 25,
							areaMinHeight		: 25,
							spotButtonsAlign	: 'left'
						},
						animation : {
							directionIn			: 'bottom',
							directionOut		: 'fade',
							easingIn			: 'easeOutQuart',
							easingOut			: 'easeInBack',
							durationIn			: 500,
							durationOut 		: 250,
							delay				: 30,
							spotBubbleDuration	: 200,
							spotBubbleEasing	: 'easeOutBack'
						},
						language : {
							areaCaption 		: 'add a name or caption',
							spotTitle			: 'Sample Title',
							spotContent			: 'You can write here text and you can also use HTML code. For example you can simply include an image or a link.',
							btnGoogle			: 'Goole',
							btnYouTube			: 'YouTube',
							btnVimeo			: 'Vimeo',
							btnWikipedia		: 'Wikipedia',
							btnFacebook			: 'Facebook',
							msgDisabled			: 'Disable wpStickies on this image',
							msgOver				: 'wpStickies: Click on the image to create a new spot or draw an area to tag faces.',
							msgDragSpot			: 'wpStickies: You can drag this sticky anywhere over the image by taking and moving the spot.',
							msgDragArea			: 'wpStickies: You can drag this sticky anywhere over the image by taking and moving the area.',
							msgBtnSave			: 'wpStickies: SAVE CHANGES',
							msgBtnRemove		: 'wpStickies: REMOVE THIS STICKY',
							msgBtnColor			: 'wpStickies: CHANGE THE COLOR OF THE BUBBLE',
							msgBtnSize			: 'wpStickies: CHANGE THE WIDTH OF THE BUBBLE',
							msgBtnReposition	: 'wpStickies: CHANGE THE DIRECTION OF THE BUBBLE',
							msgSave				: 'wpStickies: STICKY SAVED',
							msgRemove			: 'wpStickies: STICKY REMOVED',
							confRemove			: 'wpStickies: You clicked to remove this sticky. If you confirm, it will be permanently removed from the database. Are you sure?'
						}
					};

					// *..creating it from defaults and global, and passing options

					var wpsData = {

						o : $.extend({}, defaults, options),
						g : {
							version				: '2.1.3',
							debugMode			: false,						// For future debugging...
							padding				: $(this).is('img') ? 1 : 0,
							imageURL			: $(this).is('img') ? $(this).attr('src') : $(this).css('background-image').slice(4, -1).replace(/"/g,''),
							imageRatio			: false,
							disableStickies		: false,
							destroyed			: false
						}
					};

					// Saving the newly created settings to wpStickies data of element

					$(this).data('wpStickies', wpsData);

					// Calling wpsInit private function

					wpsInit( $(this) );
				}else{

					// If wpStickies data is present (reserved for future features)
				}
 			});
		},

		create : function(options){

			// Repeat over each element in selector

			return this.each(function(){
				wpsCreateSticky( $(this), options );
			});
		},

		destroy : function(){

			// Repeat over each element in selector

			return this.each(function(){
				wpsRemove( $(this) );
			});
		}
	};

	// wpStickies Private Functions

	// FIX v2.0 replacing $.browser function (removed from jQuery 1.9)

	var wpsBrowser = function(){

		uaMatch = function( ua ) {
			ua = ua.toLowerCase();

			var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
				/(webkit)[ \/]([\w.]+)/.exec( ua ) ||
				/(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
				/(msie) ([\w.]+)/.exec( ua ) ||
				ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
				[];

			return {
				browser: match[ 1 ] || "",
				version: match[ 2 ] || "0"
			};
		};

		var matched = uaMatch( navigator.userAgent ), browser = {};

		if ( matched.browser ) {
			browser[ matched.browser ] = true;
			browser.version = matched.version;
		}

		if ( browser.chrome ) {
			browser.webkit = true;
		} else if ( browser.webkit ) {
			browser.safari = true;
		}
		return browser;
	};

	var wpsInit = function( el ){

		var wps = el.data('wpStickies');

		// Creating global variables

		wps.g.allowToCreate = wps.o.settings.allowToCreate;
		wps.g.allowToModify = wps.o.settings.allowToModify;

		// Setting Debug Mode

		if( wps.g.debugMode ){

			wps.g.d = $('<div id="wps-debug">').appendTo('body').css({
				position : 'fixed',
				background : 'black',
				right : 0,
				top : 0,
				color : 'white',
				padding : 10,
				width : 400,
				zIndex : 10000,
				opacity : .85
			});
		}

		// Checking parent element

		if( el.parent().is('a') ){
			wps.g.isInAnchor = true;
		}

		// Preloading image

		var src = el.attr('src');

		el.load(function(){

			if( !wps.g.loading ){

				wps.g.loading = true;

				wpsGetImageRatio( el );
			}
		}).attr( 'src', src+'?cachefix');

		// BUGFIX v2.1.3 Fixed Chrome image-caching issue

		setTimeout( function(){
			el.attr( 'src', src );
		}, 500);

		// NEW FEATURE v2.0 Added $(window).resize() function for better responsive mode.

		setTimeout( function(){
			$(window).resize(function(){
				if( wps.g.destroyed !== true ){
					wpsGetImageRatio( el );
				}
			});
		}, 500);

		// Must be called again because of image-caching bugs in some browsers

		if( wpsBrowser().msie || !el.is('img') ){
			el.load();
		}
	};

	var wpsGetImageRatio = function( el ){

		var wps = el.data('wpStickies');

		if( typeof wps.g.originalWidth == 'undefined' ){

			// Getting image ratio for the first time after the page is loaded

			var tempContainer = $('<div>').css({
				position: 'absolute',
				left: -100000,
				top: -100000,
				width: 10000,
				height: 10000
			}).appendTo( $('body') );
			var img = $('<img>').addClass('.wps-tempimage').css({
				width: 'auto',
				height: 'auto',
				visibility: 'hidden'
			}).appendTo( tempContainer ).load(function(){
				var tempImg = $(this);
				setTimeout( function(){
					if( wps.g.destroyed !== true ){
						wps.g.originalWidth = tempImg.width();
						wps.g.imageRatio = wps.g.originalWidth / el.width();
						tempImg.remove();
						tempContainer.remove();
						if( el.width() > wps.o.settings.imageMinWidth - 1 && el.height() > wps.o.settings.imageMinHeight - 1 ){
							wpsAppendOverlay( el );
						}
					}
				}, 250);
			}).attr('src', wps.g.imageURL );

		}else{

			// Getting image ratio and resizing / repositioning overlay and stickies when the window is resized

			wps.g.imageRatio = wps.g.originalWidth / el.width();
			wpsRepositionOverlay( el );
			wpsResizeOverlay( el );
			for( var s=0; s < wps.g.stickies.find('.wps-sticky').length; s++ ){
				var curSticky = wps.g.stickies.find('.wps-sticky').eq(s);
				var sD = curSticky.data('stickyData');
				curSticky.css({
					width : sD.sticky.type == 'area' ? parseFloat( sD.area.width ) / wps.g.imageRatio : 'auto',
					height : sD.sticky.type == 'area' ? parseFloat( sD.area.height ) / wps.g.imageRatio : 'auto',
					left : parseFloat( sD.sticky.positionLeft ) / wps.g.imageRatio,
					top : parseFloat( sD.sticky.positionTop ) / wps.g.imageRatio
				});
			}
		}
	};

	var wpsRemove = function( el ){

		var wps = el.data('wpStickies');

		if( wps.g.msgTimer ){
			clearTimeout( wps.g.msgTimer );
		}

		if( wps.g.overlay ){
			wps.g.overlay.remove();
			wps.g.destroyed = true;
		}
	};

	var wpsAppendOverlay = function( el ){

		var wps = el.data('wpStickies');

		// Getting position of parent element

		var wpsPos = el.parent().css('position');

		// Changing it to relative if needed

		if( wpsPos != 'absolute' || wpsPos != 'relative' ){
			el.parent().css('position','relative');
		}

		// Adding the overlay DIV and main containers

		wps.g.overlay = $('<div>').addClass('wps-overlay');

		if( wps.g.isInAnchor ){
			wps.g.overlay.appendTo( el.parent().parent() );
		}else{
			wps.g.overlay.appendTo( el.parent() );
		}

		wps.g.helper = $('<div>').addClass('wps-helper').appendTo( wps.g.overlay );
		wps.g.stickies = $('<div>').addClass('wps-stickies').appendTo( wps.g.overlay );
		wps.g.btminfo = $('<div>').addClass('wps-btminfo').appendTo( wps.g.overlay );

		wps.g.disabledbox = $('<div><div class="wps-disabledbox">' + wps.o.language.msgDisabled + ' <input type="checkbox"></div></div>').addClass('wps-disabledbox-container').appendTo( wps.g.overlay );

		// Adding message box

		wps.g.messagebox = $('<div>').addClass('wps-messages').appendTo( wps.g.overlay );
		$('<div class="wps-messagebox"><div class="wps-messagebg"></div><p class="wps-message"></p></div>').appendTo( wps.g.messagebox );
		wps.g.message = wps.g.overlay.find('.wps-message');

		wpsDisableSelection( wps.g.messagebox );

		// Running functions

		wpsRepositionOverlay( el );
		wpsCreateFunctions( el );
		wpsGetStoredStickies( el );
	};

	// Repositioning overlay DIV (needed when for example the image element has changed its position because of another script)

	var wpsRepositionOverlay = function( el ){

		var wps = el.data('wpStickies');

		// BUGFIX v1.51 isInAnchor bugfix

		if( wps.g.isInAnchor ){
			var elP = wps.g.anchorElement = el.parent();
			el.insertBefore( elP );
			elP.empty().addClass('wps-anchor');
			wps.g.isInAnchor = false;
		}

		var mL = parseInt( el.css('margin-left') );
		if( wpsBrowser().msie && el.css('margin-left') == 'auto' ){
			mL = 0;
		}

		var mT = parseInt( el.css('margin-top') );
		if( wpsBrowser().msie && el.css('margin-top') == 'auto' ){
			mT = 0;
		}

		var bLW = isNaN( parseInt( el.css('border-left-width') ) ) ? 0 : parseInt( el.css('border-left-width') );
		var bTW = isNaN( parseInt( el.css('border-top-width') ) ) ? 0 : parseInt( el.css('border-top-width') );

		wps.g.l = el.position().left + mL + wps.g.padding * parseInt( el.css('padding-left') ) + bLW;
		wps.g.t = el.position().top + mT + wps.g.padding * parseInt( el.css('padding-top') ) + bTW;

		wps.g.overlay.css({
			left : wps.g.l,
			top : wps.g.t
		});

		if( wps.g.anchorElement ){
			wps.g.anchorElement.css({
				width : el.width(),
				height : el.height(),
				left : wps.g.l,
				top : wps.g.t
			});
		}
	};

	// Resizing overlay DIV (needed when for example the image element has changed its dimensions or other style properties like margin, padding, border...)

	var wpsResizeOverlay = function( el ){

		var wps = el.data('wpStickies');

		if( el.is('img') ){
			wps.g.w = el.width();
			wps.g.h = el.height();
		}else{
			wps.g.w = el.outerWidth();
			wps.g.h = el.outerHeight();
		}

		wps.g.ow = el.outerWidth();
		wps.g.oh = el.outerHeight();

		wps.g.overlay.css({
			width : wps.g.w,
			height : wps.g.h
		});

		var bLW = isNaN( parseInt( el.css('border-left-width') ) ) ? 0 : parseInt( el.css('border-left-width') );
		var bTW = isNaN( parseInt( el.css('border-top-width') ) ) ? 0 : parseInt( el.css('border-top-width') );

		wps.g.helper.css({
			width : wps.g.ow,
			height : wps.g.oh,
			left : - wps.g.padding * ( parseInt( el.css('padding-left') ) + bLW ),
			top : - wps.g.padding * ( parseInt( el.css('padding-top') ) + bTW )
		});
	};

	var wpsDisableStickies = function( el ){

		var wps = el.data('wpStickies');

		wps.g.stickies.addClass('wps-hidden');
		wps.g.helper.addClass('wps-hidden');
		wps.g.disableStickies = true;
		wps.g.overlay.css({
			height: 0
		});
		if( wps.g.anchorElement ){
			wps.g.anchorElement.css({
				display: 'block'
			});
		}
	};

	var wpsEnableStickies = function( el ){

		var wps = el.data('wpStickies');

		wps.g.stickies.removeClass('wps-hidden');
		wps.g.helper.removeClass('wps-hidden');
		wps.g.disableStickies = false;
		wpsResizeOverlay( el );
		if( wps.g.anchorElement ){
			wps.g.anchorElement.css({
				display: 'none'
			});
		}
	};

	// Functions of the overlay DIV and main containers

	var wpsCreateFunctions = function( el ){

		var wps = el.data('wpStickies');

		// Disable wpStickies on current image

		wps.g.disabledbox.find('input').click(function(e){
			e.stopPropagation();
			if( $(this).prop('checked') ){
				$.post( WPStickies.ajaxurl+'?'+(new Date().getTime()), { action : 'wpstickies_image_settings', image : wps.g.imageURL, data : { disabled : 'true' } }, function(data){
					wpsDisableStickies( el );
				});
			}else{
				$.post( WPStickies.ajaxurl+'?'+(new Date().getTime()), { action : 'wpstickies_image_settings', image : wps.g.imageURL, data : { disabled : 'false' } }, function(data){
					wpsEnableStickies( el );
				});
			}
		});

		// Mouse-over function of the image element

		if( wps.g.anchorElement && wps.o.settings.role == 'administrator' ){
			wps.g.anchorElement.mouseover(function(){

				wps.g.overlay.css({
					display: 'block'
				});
				wpsRepositionOverlay( el );
				wpsResizeOverlay( el );

				if( !wps.o.settings.alwaysVisible || wps.o.settings.alwaysVisible && wps.g.visible ){
					wps.g.disabledbox.stop(true, true).slideDown(200);
				}
			});
		}

		if( el.hasClass('wps-allow-to-create-on-demo-site') ){
			wps.g.allowToCreate = true;
			wps.g.allowToModify = true;
		}

		el.mouseover(function(){

			// Showing disabledbox

			if( wps.o.settings.role == 'administrator' ){
				if( !wps.o.settings.alwaysVisible || wps.o.settings.alwaysVisible && wps.g.visible ){
					wps.g.disabledbox.stop(true, true).slideDown(200);
				}
			}

			wpsRepositionOverlay( el );
			wpsResizeOverlay( el );

			if( wps.g.disableStickies ){
				wps.g.overlay.css({
					height: 0
				}).fadeIn( fDu );
			}else{

				// Setting animation directionIn

				var mL = 0;
				var mT = -wps.g.h;
				var fDu = wps.o.animation.durationIn / 3;
				var fDe = wps.o.animation.durationIn / 4;
				var dIn = wps.o.animation.durationIn;
				var delay = wps.o.animation.delay;

				switch( wps.o.animation.directionIn ){

					case 'fade':
						mL = 0;
						mT = 0;
						delay = 0;
						fDu = wps.o.animation.durationIn;
						dIn = 0;
						fDe = 0;
					break;
					case 'left':
						mL = -wps.g.w;
						mT = 0;
					break;
					case 'right':
						mL = wps.g.w;
						mT = 0;
					break;
					case 'bottom':
						mL = 0;
						mT = wps.g.h;
					break;
					default:
						mL = 0;
						mT = -wps.g.h;
				}

				// Showing stickies with a custom delay

				wps.g.overlay.fadeIn( fDu );

				wps.g.stickies.find('.wps-sticky').each(function(){
					$(this).css({
						marginLeft : mL,
						marginTop : mT,
						display : 'none'
					}).stop(true,true);

					var sticky = $(this);

					setTimeout( function(){
						if( wps.g.destroyed !== true ){
							sticky.animate({
								margin : 0
							}, dIn, wps.o.animation.easingIn ).dequeue().delay( fDe ).fadeIn( fDu, function(){
								if( $(this).index() == wps.g.stickies.find('.wps-sticky').length - 1 ){

									// Setting overflow

									wps.g.stickies.css({
										overflow: 'visible'
									});
								}
							});
						}
					}, sticky.index() * delay );
				});

				// Setting overflow if there are no stickies in the container

				if( !wps.g.stickies.find('.wps-sticky').length ){
					wps.g.stickies.css({
						overflow: 'visible'
					});
				}
			}
		});

		el.one('mousemove', function(){
			el.mouseover();
		});

		// Mouse-enter function of the overlay DIV

		wps.g.overlay.mouseenter(function(){
			wps.g.helper.css({
				display : 'block'
			});

			if( $(this).hasClass('wps-over') && !wps.g.visible ){
				el.mouseenter();
			}else{
				$(this).addClass('wps-over');
			}

			// Showing msgOver

			if( wps.g.allowToCreate ){
				wpsShowMessage( el, wps.o.language.msgOver, 3000 );
			}

			// Showing disabledbox

			if( wps.o.settings.role == 'administrator'){
				if( !wps.o.settings.alwaysVisible || wps.o.settings.alwaysVisible && wps.g.visible ){
					wps.g.disabledbox.stop(true, true).slideDown(200);
				}
			}
		});

		// Mouse-leave function of the overlay DIV

		wps.g.overlay.mouseleave(function(){

			// Hiding disabledbox

			if( wps.o.settings.role == 'administrator' ){
				wps.g.disabledbox.stop(true, true).slideUp(200);
			}

			if( !wps.o.settings.alwaysVisible ){

				// Hiding msgOver

				wpsHideMessage( el );

				// Setting overflow

				wps.g.stickies.css({
					overflow: 'hidden'
				});

				// Setting animation directionOut

				var mL = 0;
				var mT = -wps.g.h;
				var fDu = 1;
				var fDe = wps.g.stickies.find('.wps-sticky').length * wps.o.animation.delay + wps.o.animation.durationOut;

				switch( wps.o.animation.directionOut ){

					case 'fade':
						mL = 0;
						mT = 0;
						fDu = wps.o.animation.durationOut;
						fDe = 1;
						wps.o.animation.delayOut = 0;
					break;
					case 'left':
						mL = -wps.g.w;
						mT = 0;
					break;
					case 'right':
						mL = wps.g.w;
						mT = 0;
					break;
					case 'bottom':
						mL = 0;
						mT = wps.g.h;
					break;
					default:
						mL = 0;
						mT = -wps.g.h;
				}

				// Hiding stickies with a custom delay

				wps.g.stickies.find('.wps-sticky').each(function(){
					$(this).stop(true,true).delay( $(this).index() * wps.o.animation.delay ).animate({
						marginLeft : mL,
						marginTop : mT
					}, wps.o.animation.durationOut, wps.o.animation.easingOut );
				});

				$(this).delay( fDe  ).fadeOut( fDu, function(){
					$(this).removeClass('wps-over');
				});
			}
		});

		// Start of dragging or start of creating a sticky

		wps.g.stickies.mousedown(function( e ){
			wps.g.mouseLeftStart = e.pageX - wps.g.overlay.offset().left;
			wps.g.mouseTopStart = e.pageY - wps.g.overlay.offset().top;

			if( !wps.g.overSticky && wps.g.allowToCreate ){
				wpsCreateSticky( el );
			}
		});

		// Finish of dragging or finish of creating a sticky

		wps.g.stickies.mouseup(function( e ){

			var curSticky = wps.g.stickies.find('.wps-creating');
			var sD = curSticky.data('stickyData');

			if( curSticky.hasClass('wps-creating') ){

				var mouseLeft = e.pageX - wps.g.overlay.offset().left;
				var mouseTop = e.pageY - wps.g.overlay.offset().top;

				if( Math.abs( mouseLeft - wps.g.mouseLeftStart ) < wps.o.position.areaMinWidth && Math.abs( mouseTop - wps.g.mouseTopStart ) < wps.o.position.areaMinHeight ){
					curSticky.removeClass('wps-area').addClass('wps-spot').css({
						left : mouseLeft - curSticky.width() / 2,
						top : mouseTop - curSticky.height() / 2,
						width : 'auto',
						height : 'auto'
					});

					sD.sticky.type = 'spot';
				}else{
					curSticky.css({
						left : curSticky.position().left,
						top : curSticky.position().top,
						right : 'auto',
						bottom : 'auto'
					});

					curSticky.find('.wps-areacaption').css({
						marginLeft: - curSticky.find('.wps-areacaption').width() / 2
					});
				}

				// Sticky created, removing class

				curSticky.removeClass('wps-creating');

				// Adding remove button

				wpsAddRemove( el, curSticky );

				if( curSticky.hasClass('wps-area') && curSticky.hasClass('wps-editable') ){
					wpsAreaEdit( el, curSticky );
				}
			}
		});

		// Dragging a sticky or creating an area

		wps.g.stickies.mousemove(function( e ){

			var mouseLeft = e.pageX - wps.g.overlay.offset().left;
			var mouseTop = e.pageY - wps.g.overlay.offset().top;

			// Dragging a sticky

			if( wps.g.stickies.find('.wps-dragging').length ){
				wps.g.stickies.find('.wps-dragging').css({
					left : mouseLeft - ( wps.g.mouseLeftStart - wps.g.dragLeftStart ),
					top : mouseTop - ( wps.g.mouseTopStart - wps.g.dragTopStart )
				});
			}

			// Creating an area

			if( mouseLeft - wps.g.mouseLeftStart < 0 ){
				wps.g.stickies.find('.wps-creating').css({
					right : wps.g.w - wps.g.mouseLeftStart,
					left : 'auto'
				});
			}else{
				wps.g.stickies.find('.wps-creating').css({
					right : 'auto',
					left : wps.g.mouseLeftStart
				});
			}

			if( mouseTop - wps.g.mouseTopStart < 0 ){
				wps.g.stickies.find('.wps-creating').css({
					bottom : wps.g.h - wps.g.mouseTopStart,
					top : 'auto'
				});
			}else{
				wps.g.stickies.find('.wps-creating').css({
					bottom : 'auto',
					top : wps.g.mouseTopStart
				});
			}

			wps.g.stickies.find('.wps-creating').css({
				width : Math.abs( mouseLeft - wps.g.mouseLeftStart ),
				height : Math.abs( mouseTop - wps.g.mouseTopStart )
			});
		});
	};

	// Getting stored sticky data from database

	var wpsGetStoredStickies = function( el ){

		var wps = el.data('wpStickies');

		$.getJSON( WPStickies.ajaxurl+'?'+(new Date().getTime()), { action : 'wpstickies_get', image : wps.g.imageURL }, function(data){

			if( data['settings']['disabled'] == 'true' ){
				wps.g.disabledbox.find('input').prop('checked', true);
				wpsDisableStickies( el );
			}else{
				wpsEnableStickies( el );
			}

			if( data['stickies'] ){
				for(var x=0;x<data['stickies'].length;x++){
					wpsCreateSticky( el, data['stickies'][x] );
				}
			}

			if( wps.o.settings.alwaysVisible ){
				el.mouseover();
				wps.g.overlay.mouseenter();
				wps.g.visible = true;
			}
		});
	};

	// Creating a sticky, adding sticky functions

	var wpsCreateSticky = function( el, newStickyData, e ){

		var wps = el.data('wpStickies');

		// Creating sticky element

		var curSticky = $('<div>');

		// Saving stickyData into curSticky.data onbject

		curSticky.data('stickyData', $.extend({
			sticky : {
				type			: 'area',
				positionLeft	: wps.g.mouseLeftStart / wps.g.imageRatio,
				positionTop		: wps.g.mouseTopStart / wps.g.imageRatio,
				allowToModify	: true
			},
			area : {
				width			: 'auto',
				height			: 'auto',
				caption			: '',
				captionRaw		: ''
			},
			spot : {
				bubbleDirection	: wps.o.position.spotBubbleDirection,
				title			: '',
				content			: '',

				// NEW FEATURE v2.0 parsing shortcodes

				titleRaw		: '',
				contentRaw		: '',
				size			: 0,
				color			: 'white',
				urlSpot			: '',
				urlSpotTarget	: '_self',
				urlGoogle		: '',
				urlYouTube		: '',
				urlVimeo		: '',
				urlWikipedia	: '',
				urlFacebook		: ''
			}
		}, newStickyData ));

		var sD = curSticky.data('stickyData');

		// NEW FEATURE v2.0 - most be check due to compatibility!

		if( !sD.area.captionRaw ){
			sD.area.captionRaw = sD.area.caption;
		}

		if( !sD.spot.contentRaw ){
			sD.spot.contentRaw = sD.spot.content;
		}

		if( !sD.spot.titleRaw ){
			sD.spot.titleRaw = sD.spot.title;
		}

		// NEW FEATURES v1.1 - most be check due to compatibility!

		if( !sD.spot.urlSpot ){
			sD.spot.urlSpot = '';
		}

		if( !sD.spot.urlSpotTarget ){
			sD.spot.urlSpotTarget = '_self';
		}

		var userCreating = sD.sticky.id ? 'wps-saved' : 'wps-creating wps-editable wps-forceedit';

		// Appending current sticky

		curSticky.addClass('wps-sticky wps-' + sD.spot.bubbleDirection + ' ' + 'wps-' + sD.sticky.type + ' '+userCreating).css({
			width : sD.sticky.type == 'area' ? parseFloat( sD.area.width ) / wps.g.imageRatio : 'auto',
			height : sD.sticky.type == 'area' ? parseFloat( sD.area.height ) / wps.g.imageRatio : 'auto',
			left : parseFloat( sD.sticky.positionLeft ) / wps.g.imageRatio,
			top : parseFloat( sD.sticky.positionTop ) / wps.g.imageRatio
		}).appendTo( wps.g.stickies );

		// Adding HTML markup

		var curStickyBG = $('<div class="wps-stickybg"></div>');
		var curAreaCaption = $('<div class="wps-areacaption"><div class="wps-bg"></div><p class="wps-areacaptiontext">' + sD.area.caption + '</p></div><input class="wps-areacaptioneditable" placeholder="' + wps.o.language.areaCaption + '" value="' + sD.area.captionRaw + '">');
		var curAreaControls =  $('<div class="wps-areacontrols"><a href="#" class="wps-modify"></a><a href="#" class="wps-save"></a></div>');
		var curSpotBubble = $('<div class="wps-spotbubble"><div class="wps-spotborder"></div><div class="wps-spotbubble-bg"></div><div class="wps-spotarrow"></div><input class="wps-spottitleeditable" placeholder="' + wps.o.language.spotTitle + '" value="' + sD.spot.titleRaw + '"><h1 class="wps-spottitle">' + sD.spot.title + '</h1><textarea class="wps-spotcontenteditable" placeholder="' + wps.o.language.spotContent + '">' + sD.spot.contentRaw + '</textarea><div class="wps-spotcontent">' + sD.spot.content + '</div><div class="wps-logos" style="text-align: ' + wps.o.position.spotButtonsAlign + ';"><a class="wps-logo wps-google wps-logo-active" target="_blank" href="' + sD.spot.urlGoogle + '"><span></span></a><a class="wps-logo wps-youtube" target="_blank" href="' + sD.spot.urlYouTube + '"><span></span></a><a class="wps-logo wps-vimeo" target="_blank" href="' + sD.spot.urlVimeo + '"><span></span></a><a class="wps-logo wps-wikipedia" target="_blank" href="' + sD.spot.urlWikipedia + '"><span></span></a><a class="wps-logo wps-facebook" target="_blank" href="' + sD.spot.urlFacebook + '"><span></span></a></div><div class="wps-urls"><input class="wps-urleditable wps-urleditable-active" value="' + sD.spot.urlGoogle + '"><input class="wps-urleditable" value="' + sD.spot.urlYouTube + '"><input class="wps-urleditable" value="' + sD.spot.urlVimeo + '"><input class="wps-urleditable" value="' + sD.spot.urlWikipedia + '"><input class="wps-urleditable" value="' + sD.spot.urlFacebook + '"></div><div class="wps-spoturleditable-container">Spot URL | open in new tab? <input class="wps-spoturltarget" type="checkbox"><input class="wps-spoturleditable" value="' + sD.spot.urlSpot + '"></div><div class="wps-controls"><a href="#" class="wps-modify"></a><a href="#" class="wps-position"></a><a href="#" class="wps-color"></a><a href="#" class="wps-size"></a><a href="#" class="wps-save"></a></div></div><div class="wps-spothelper"><a class="wps-spoturl" href="' + sD.spot.urlSpot + '"></a></div>');

		curStickyBG.appendTo( curSticky );
		curAreaCaption.appendTo( curSticky );
		curAreaControls.appendTo( curSticky );
		curSpotBubble.appendTo( curSticky );

		// SpotBubble Color

		if( sD.spot.color && sD.spot.color == 'black' ){
			curSticky.find('.wps-spotbubble').addClass('wps-black');
			curSticky.addClass('wps-spotblack');
		}

		// SpotBubble Size

		if( sD.spot.size ){
			switch( parseInt(sD.spot.size) ){
				case 0:
				break;
				case 1:
					curSticky.addClass('wps-medium');
				break;
				case 2:
					curSticky.addClass('wps-big');
				break;
			}
		}

		// SpotURL checkbox

		if( sD.spot.urlSpotTarget == '_blank' ){
			curSticky.find('.wps-spoturltarget').prop('checked',true);
		}

		// Disabling text selection

		if( sD.sticky.id ){
			wpsDisableSelection( curSticky );
		}

		wpsDisableSelection( curSticky.find('.wps-spothelper') );

		// Creating functions of control buttons

		curSticky.find('.wps-save').click(function(e){
			e.preventDefault();
			e.stopPropagation();

			// Creating variables

			var spotSize = 0;

			if( curSticky.hasClass('wps-medium') ){
				spotSize = 1;
			}else if( curSticky.hasClass('wps-big') ){
				spotSize = 2;
			}

			// Storing changes into curSticky.data obejct

			$.extend( sD, {
				sticky : {
					type			: sD.sticky.type,
					positionLeft	: curSticky.position().left * wps.g.imageRatio,
					positionTop		: curSticky.position().top * wps.g.imageRatio,
					id				: sD.sticky.id ? sD.sticky.id : false,
					allowToModify	: sD.sticky.allowToModify
				},
				area : {
					width			: sD.sticky.type == 'area' ? curSticky.width() * wps.g.imageRatio : 'auto',
					height			: sD.sticky.type == 'area' ? curSticky.height() * wps.g.imageRatio : 'auto',
					caption			: curSticky.find('.wps-areacaptiontext').html(),
					captionRaw		: curSticky.find('.wps-areacaptioneditable').val()
				},
				spot : {
					bubbleDirection	: sD.spot.bubbleDirection,
					title			: curSticky.find('.wps-spottitle').html(),
					content			: curSticky.find('.wps-spotcontent').html(),

					// NEW FEATURE v2.0 parsing shortcodes

					titleRaw		: curSticky.find('.wps-spottitleeditable').val(),
					contentRaw		: curSticky.find('.wps-spotcontenteditable').val(),
					size			: spotSize,
					color			: curSticky.hasClass('wps-spotblack') ? 'black' : 'white',
					urlSpot			: curSticky.find('.wps-spoturl').attr('href'),
					urlSpotTarget	: curSticky.find('.wps-spoturltarget').prop('checked') ? '_blank' : '_self',
					urlGoogle		: curSticky.find('.wps-google').attr('href'),
					urlYouTube		: curSticky.find('.wps-youtube').attr('href'),
					urlVimeo		: curSticky.find('.wps-vimeo').attr('href'),
					urlWikipedia	: curSticky.find('.wps-wikipedia').attr('href'),
					urlFacebook		: curSticky.find('.wps-facebook').attr('href')
				}
			});

			if( curSticky.hasClass('wps-saved') ){
				$.post( WPStickies.ajaxurl+'?'+(new Date().getTime()), { action : 'wpstickies_update', data : sD, id : sD.sticky.id, image : wps.g.imageURL }, function( data ) {

					var data = $.parseJSON(data);

					if( data['errorCount'] == 0 ){
						curSticky.removeClass('wps-editing').removeClass('wps-forceedit').mouseout();

						// Setting rights

						wpsAllowEdit( curSticky )

						// Showing or hiding linkbuttons

						wpsSetContent( el, curSticky );

					}else{
						alert( data['message'] );
					}

					// Inserting parsed HTML into spot content

					curSticky.find('.wps-spotcontent').html( data['content'] );
					curSticky.find('.wps-spottitle').html( data['title'] );
					curSticky.find('.wps-areacaptiontext').html( data['caption'] );
				});
			}else{
				$.post( WPStickies.ajaxurl+'?'+(new Date().getTime()), { action : 'wpstickies_insert', data : sD, image : wps.g.imageURL }, function( data ) {

					var data = $.parseJSON(data);

					if( data['errorCount'] == 0 ){
						curSticky.addClass('wps-saved');
						sD.sticky.id = parseInt( data['id'] );
						sD.sticky.allowToModify = data['allowToModify'];

						// Setting rights

						wpsAllowEdit( curSticky )

						// Showing or hiding linkbuttons

						wpsSetContent( el, curSticky );

						curSticky.removeClass('wps-editing').removeClass('wps-forceedit').mouseout();
					}else{
						alert( data['message'] );
					}

					// Inserting parsed HTML into spot content

					curSticky.find('.wps-spotcontent').html( data['content'] );
					curSticky.find('.wps-spottitle').html( data['title'] );
					curSticky.find('.wps-areacaptiontext').html( data['caption'] );
				});
			}

			// Disabling text selection

			wpsDisableSelection( curSticky );
		});

		curSticky.find('.wps-position').click(function(e){
			e.preventDefault();
			e.stopPropagation();
			if( curSticky.hasClass('wps-left') ){
				wpsRepositionSticky( curSticky, 'top' );
			}else if( curSticky.hasClass('wps-top') ){
				wpsRepositionSticky( curSticky, 'right' );
			}else if( curSticky.hasClass('wps-right') ){
				wpsRepositionSticky( curSticky, 'bottom' );
			}else if( curSticky.hasClass('wps-bottom') ){
				wpsRepositionSticky( curSticky, 'left' );
			}
		});

		curSticky.find('.wps-color').click(function(e){
			e.preventDefault();
			e.stopPropagation();
			if( curSticky.hasClass('wps-spotblack') ){
				curSticky.removeClass('wps-spotblack');
				curSticky.find('.wps-spotbubble').removeClass('wps-black');
			}else{
				curSticky.addClass('wps-spotblack');
				curSticky.find('.wps-spotbubble').addClass('wps-black');
			}
		});

		curSticky.find('.wps-size').click(function(e){
			e.preventDefault();
			e.stopPropagation();
			if( !curSticky.hasClass('wps-medium') && !curSticky.hasClass('wps-big') ){
				curSticky.addClass('wps-medium');
			}else if( curSticky.hasClass('wps-medium') ){
				curSticky.removeClass('wps-medium').addClass('wps-big');
			}else if( curSticky.hasClass('wps-big') ){
				curSticky.removeClass('wps-big');
			}
			wpsRepositionSticky( curSticky, curSticky.data('stickyData').spot.bubbleDirection );
		});

		// Creating hover functions of control buttons

		curSticky.find('.wps-save').hover(
			function(){
				wpsShowMessage( el, wps.o.language.msgBtnSave, 2000 );
			},
			function(){
				wpsHideMessage( el );
			}
		);

		curSticky.find('.wps-position').hover(
			function(){
				wpsShowMessage( el, wps.o.language.msgBtnReposition, 2000 );
			},
			function(){
				wpsHideMessage( el );
			}
		);

		curSticky.find('.wps-color').hover(
			function(){
				wpsShowMessage( el, wps.o.language.msgBtnColor, 2000 );
			},
			function(){
				wpsHideMessage( el );
			}
		);

		curSticky.find('.wps-size').hover(
			function(){
				wpsShowMessage( el, wps.o.language.msgBtnSize, 2000 );
			},
			function(){
				wpsHideMessage( el );
			}
		);

		curSticky.find('.wps-remove').hover(
			function(){
				wpsShowMessage( el, wps.o.language.msgBtnRemove, 2000 );
			},
			function(){
				wpsHideMessage( el );
			}
		);

		// Creating content editing functions

		curSticky.find('.wps-logo').click(function(e){
			if( curSticky.hasClass('wps-editing') ){
				e.preventDefault();
				curSticky.find('.wps-logo').removeClass('wps-logo-active');
				curSticky.find('.wps-urleditable').removeClass('wps-urleditable-active');
				$(this).addClass('wps-logo-active');
				curSticky.find('.wps-urls .wps-urleditable:eq('+$(this).index()+')').addClass('wps-urleditable-active');
			}
		});

		curSticky.find('.wps-urleditable').keyup(function(){
			curSticky.find('.wps-logos .wps-logo:eq(' + $(this).index() + ')').attr( 'href', $(this).val() );
		});

		curSticky.find('.wps-spoturleditable').keyup(function(){
			curSticky.find('.wps-spoturl').attr( 'href', $(this).val() );
		});

		curSticky.find('.wps-spottitleeditable').keyup(function(){
			curSticky.find('.wps-spottitle').html( $(this).val() );
		});

		curSticky.find('.wps-spotcontenteditable').keyup(function(){
			curSticky.find('.wps-spotcontent').html( $(this).val() );
		});

		curSticky.find('.wps-areacaptioneditable').keyup(function(){
			curSticky.find('.wps-areacaptiontext').html( $(this).val() );
			curSticky.find('.wps-areacaption').css({
				marginLeft: - curSticky.find('.wps-areacaption').width() / 2
			});
		});

		curSticky.find('.wps-areacaptioneditable, .wps-spotcontenteditable, .wps-spottitleeditable, .wps-spotbubble, .wps-spotborder').mousemove(function(e){
			e.stopPropagation();
		});

		curSticky.find('.wps-areacaptioneditable, .wps-spotcontenteditable, .wps-spottitleeditable, .wps-spotbubble, .wps-spotborder').mousedown(function(e){
			e.stopPropagation();
		});

		// Creating sticky functions

		curSticky.find('.wps-modify').click(function(e){
			e.preventDefault();
			if( curSticky.data('stickyData').sticky.allowToModify ){
				if( curSticky.hasClass('wps-spot') ){
					wpsSpotEdit( curSticky );
				}else{
					wpsAreaEdit( el, curSticky );
				}
			}
			curSticky.removeClass('wps-unselectable');
		});

		curSticky.mousedown(function(){
			if( $(this).hasClass('wps-editing') ){
				$(this).addClass('wps-dragging');
				wps.g.dragLeftStart = $(this).position().left;
				wps.g.dragTopStart = $(this).position().top;
			}
		});

		curSticky.mouseup(function(e){

			// Checking the end position of dragging

			if( $(this).hasClass('wps-dragging') ){
				var mouseLeft = e.pageX - wps.g.overlay.offset().left;
				var mouseTop = e.pageY - wps.g.overlay.offset().top;

				var dragLeftOriginal = dragLeft = mouseLeft - ( wps.g.mouseLeftStart - wps.g.dragLeftStart );

				if( $(this).position().left < 0 ){
					dragLeft = 0;
				}else if( $(this).position().left > wps.g.stickies.width() - $(this).outerWidth() ){
					dragLeft = wps.g.stickies.width() - $(this).outerWidth();
				}

				var dragTopOriginal = dragTop = mouseTop - ( wps.g.mouseTopStart - wps.g.dragTopStart );

				if( $(this).position().top < 0 ){
					dragTop = 0;
				}else if( $(this).position().top > wps.g.stickies.height() - $(this).outerHeight() ){
					dragTop = wps.g.stickies.height() - $(this).outerHeight();
				}

				if( dragLeftOriginal != dragLeft || dragTopOriginal != dragTop ){

					$(this).animate({
						left : dragLeft,
						top : dragTop
					}, 300, 'easeInOutQuart');
				}

				$(this).removeClass('wps-dragging');

			}else{

				// BUGFIX v1.5 Firefox didn't show spotbubble if a new spot was created

				if( curSticky.hasClass('wps-creating') && curSticky.hasClass('wps-spot') ){
					curSticky.css({
						marginLeft : -100,
						visibility : 'hidden'
					}).delay(50).animate({
						marginLeft : 0
					},0,function(){
						$(this).css({
							visibility : 'visible'
						});
					});
				}
			}
		});

		curSticky.hover(
			function(){
				if( !$(this).hasClass('wps-creating') && !$(this).find('.wps-spotbubble').hasClass('wps-hidden') ){
					$(this).addClass('wps-sticky-over');
					wps.g.overSticky = true;

					if( !$(this).hasClass('wps-editing') ){

						if( $(this).hasClass('wps-forceedit') ){
							$(this).addClass('wps-editing');
						}

						if( $(this).hasClass('wps-spot' ) ){

							var wpsSpotBubble = $(this).find('.wps-spotbubble');

							// Selecting SpotBubble direction

							var spotBubbleDirection;

							wpsSpotBubble.css({
								visibility: 'hidden',
								display : 'block'
							});

							// BUGFIX v2.0.1 Fixed spotBubble horizontal positioning issues

							if( $(this).hasClass('wps-top') ){
								spotBubbleDirection = 'top';

								if( wps.o.position.autoChangeDirection && $(this).offset().top - wpsSpotBubble.outerHeight() - wps.o.position.spotBubbleDistance - 10 - $(document).scrollTop() < 0 ){
									$(this).addClass('wps-forcebottom');
									spotBubbleDirection = 'bottom';
								}
							}else if( $(this).hasClass('wps-bottom') ){
								spotBubbleDirection = 'bottom';

								if( wps.o.position.autoChangeDirection && $(this).height() + $(this).offset().top + wpsSpotBubble.outerHeight() + wps.o.position.spotBubbleDistance + 10 > $(document).scrollTop() + $(window).height() ){
									$(this).addClass('wps-forcetop');
									spotBubbleDirection = 'top';
								}
							}else if( $(this).hasClass('wps-left') ){
								spotBubbleDirection = 'left';
								if( wps.o.position.autoChangeDirection && $(this).offset().left - wpsSpotBubble.outerWidth() - wps.o.position.spotBubbleDistance - 10 - $(document).scrollLeft() < 0 && $(this).width() + $(this).offset().left + wpsSpotBubble.outerWidth() - wps.o.position.spotBubbleDistance + 10 < $(document).scrollLeft() + $(window).width() ){

									$(this).addClass('wps-forceright');
									spotBubbleDirection = 'right';
								}
							}else if( $(this).hasClass('wps-right') ){
								spotBubbleDirection = 'right';

								if( wps.o.position.autoChangeDirection && $(this).width() + $(this).offset().left + wpsSpotBubble.outerWidth() - wps.o.position.spotBubbleDistance + 10 > $(document).scrollLeft() + $(window).width() && $(this).offset().left - wpsSpotBubble.outerWidth() - wps.o.position.spotBubbleDistance - 10 - $(document).scrollLeft() > 0){
									$(this).addClass('wps-forceleft');
									spotBubbleDirection = 'left';
								}
							}

							// SpotBubble direction default variables created for 'top':

							var	curMarginLeft = - ( $(this).find('.wps-spotbubble').outerWidth() / 2 );
							var curMarginRight = 0;
							var curMarginTop = 0;
							var curMarginBottom = 0;
							var curMarginLeftStart =  - ( $(this).find('.wps-spotbubble').outerWidth() / 2 );
							var curMarginRightStart = 0;
							var curMarginTopStart = 0;
							var curMarginBottomStart = 50;

							var bLW = isNaN( parseInt( $(this).find('.wps-spotarrow').css('border-left-width') ) ) ? 0 : parseInt( $(this).find('.wps-spotarrow').css('border-left-width') );
							var bRW = isNaN( parseInt( $(this).find('.wps-spotarrow').css('border-right-width') ) ) ? 0 : parseInt( $(this).find('.wps-spotarrow').css('border-right-width') );
							var bTW = isNaN( parseInt( $(this).find('.wps-spotarrow').css('border-top-width') ) ) ? 0 : parseInt( $(this).find('.wps-spotarrow').css('border-top-width') );
							var bBW = isNaN( parseInt( $(this).find('.wps-spotarrow').css('border-bottom-width') ) ) ? 0 : parseInt( $(this).find('.wps-spotarrow').css('border-bottom-width') );

							var curLeft = '50%';
							var curRight = 'auto';
							var curTop = 'auto';
							var curBottom = $(this).height() + bTW + wps.o.position.spotBubbleDistance;

							switch( spotBubbleDirection ){

								case 'bottom':
									curMarginTop = 0;
									curMarginBottom = 0;
									curMarginTopStart = 50;
									curMarginBottomStart = 0;

									curTop = $(this).height() + bBW + wps.o.position.spotBubbleDistance;
									curBottom = 'auto';
								break;

								case 'left':
									curMarginLeft = 0;
									curMarginRight = 0;
									curMarginTop =  - ( wpsSpotBubble.height() + $(this).height() ) / 2 - 1;
									curMarginBottom = 0;
									curMarginLeftStart = 0;
									curMarginRightStart = 50;
									curMarginTopStart = - ( wpsSpotBubble.height() + $(this).height() ) / 2 - 1;
									curMarginBottomStart = 0;

									curLeft = 'auto';
									curRight = $(this).width() + bLW + wps.o.position.spotBubbleDistance;
									curTop = '50%';
									curBottom = 'auto';
								break;

								case 'right':
									curMarginLeft = 0;
									curMarginRight = 0;
									curMarginTop =  - ( wpsSpotBubble.height() + $(this).height() ) / 2 - 1;
									curMarginBottom = 0;
									curMarginLeftStart = 50;
									curMarginRightStart = 0;
									curMarginTopStart = - ( wpsSpotBubble.height() + $(this).height() ) / 2 - 1;
									curMarginBottomStart = 0;

									curLeft = $(this).width() + bRW + wps.o.position.spotBubbleDistance;
									curRight = 'auto';
									curTop = '50%';
									curBottom = 'auto';
								break;
							}

							wpsSpotBubble.css({
								display : 'none',
								visibility: 'visible',
								left : curLeft,
								right : curRight,
								top : curTop,
								bottom : curBottom,
								marginLeft : curMarginLeftStart,
								marginRight : curMarginRightStart,
								marginTop : curMarginTopStart,
								marginBottom : curMarginBottomStart
							}).stop(true, true).animate({
								marginLeft : curMarginLeft,
								marginRight : curMarginRight,
								marginTop : curMarginTop,
								marginBottom : curMarginBottom
							},wps.o.animation.spotBubbleDuration, wps.o.animation.spotBubbleEasing, function(){
								$(this).css({
									left : $(this).position().left + curMarginLeft,
									marginLeft : 0
								});
							}).dequeue().fadeIn( wps.o.animation.spotBubbleDuration );
						}else{
							if( $(this).hasClass('wps-editable') ){
								$(this).find('.wps-areacontrols').stop(true, true).fadeIn( 200 );
							}
						}
					}
				}
			},
			function(){
				if( !$(this).hasClass('wps-creating') ){
					if( !$(this).hasClass('wps-editing') ){
						if( $(this).hasClass('wps-spot') ){
							$(this).find('.wps-spotbubble').stop(true, true).fadeOut( wps.o.animation.durationOut, function(){
								if( !$(this).parent().hasClass('wps-sticky-over') ){
									$(this).parent().removeClass('wps-forcetop').removeClass('wps-forcebottom').removeClass('wps-forceleft').removeClass('wps-forceright');
								}
							});
						}
					}
					if( $(this).hasClass('wps-area') && $(this).hasClass('wps-editable') && !$(this).hasClass('wps-editing') ){
						$(this).find('.wps-areacontrols').stop(true, true).fadeOut( 200 );
					}

					$(this).removeClass('wps-sticky-over');
					wps.g.overSticky = false;
				}
			}
		);

		// Positioning the caption of the area

		if( newStickyData && newStickyData.sticky.type == 'area' ){
			wps.g.overlay.css({
				visibiliy : 'hidden',
				display : 'block'
			});
			curSticky.find('.wps-areacaption').css({
				marginLeft: - curSticky.find('.wps-areacaption').width() / 2
			});
			wps.g.overlay.css({
				display : 'none',
				visibiliy : 'visible'
			});
		}

		// Setting the visibility of the spot content

		if( curSticky.hasClass('wps-saved') ){

			// Setting rights

			wpsAllowEdit( curSticky );

			// Showing or hiding linkbuttons

			wpsSetContent( el, curSticky );

		 	// Adding remove button

			wpsAddRemove( el, curSticky );
		}
	};

	// Removing sticky

	var wpsRemoveSticky = function( el, curSticky ){

		var wps = el.data('wpStickies');

		if( curSticky.hasClass('wps-saved') ){

			$.post( WPStickies.ajaxurl+'?'+(new Date().getTime()), { action : 'wpstickies_remove', id : curSticky.data('stickyData').sticky.id, image : wps.g.imageURL }, function(data){

				var data = $.parseJSON( data );

				if( data['errorCount'] == 0 ){
					curSticky.fadeOut( 300, function(){
						curSticky.removeClass('wps-editing').mouseout();
						curSticky.remove();
					});
				}else{
					alert( data['message'] );
				}
			});
		}else{
			curSticky.fadeOut( 300, function(){
				curSticky.removeClass('wps-editing').mouseout();
				curSticky.remove();
			});
		}
	};

	// Repositioning sticky

	var wpsRepositionSticky = function( curSticky, position ){

		var sD = curSticky.data('stickyData');

		curSticky.removeClass('wps-editing').removeClass('wps-left').removeClass('wps-top').removeClass('wps-right').removeClass('wps-bottom').removeClass('wps-forceleft').removeClass('wps-forcetop').removeClass('wps-forceright').removeClass('wps-forcebottom').addClass('wps-' + position);
		curSticky.mouseover();

		sD.spot.bubbleDirection = position;
	};

	// Editing spot

	var wpsSpotEdit = function( curSticky ){

		curSticky.find('.wps-spottitleeditable').val( curSticky.data('stickyData').spot.titleRaw );
		curSticky.find('.wps-spotcontenteditable').val( curSticky.data('stickyData').spot.contentRaw );
		curSticky.find('.wps-logos, .wps-logo').removeClass('wps-hidden');
		curSticky.find('.wps-urleditable').each(function(){
			$(this).val( curSticky.find('.wps-logos .wps-logo:eq(' + $(this).index() + ')').attr('href') );
		});

		curSticky.find('.wps-spoturleditable').val( curSticky.find('.wps-spoturl').attr('href') );
		if( curSticky.data('stickyData').spot.urlSpotTarget == '_blank' ){
			curSticky.find('.wps-spoturltarget').prop('checked', true );
		}

		curSticky.find('.wps-logo:first').addClass('wps-logo-active');
		curSticky.find('.wps-urleditable:first').addClass('wps-urleditable-active');

		curSticky.addClass('wps-forceedit').mouseover();
	};

	// Editing Area

	var wpsAreaEdit = function( el, curSticky ){

		var wps = el.data('wpStickies');

		wps.g.overSticky = true;
		curSticky.addClass('wps-editing').find('.wps-areacontrols').stop(true, true).fadeIn( 200 );
		curSticky.find('wps-areacaptioneditable').val( curSticky.data('stickyData').area.captionRaw );
		curSticky.find('.wps-areacaptioneditable').focus();
	};

	var wpsAllowEdit = function( curSticky ){

		var sD = curSticky.data('stickyData');

		if( sD.sticky.allowToModify  ){
			curSticky.addClass('wps-editable');
		}else{
			curSticky.removeClass('wps-editable');
			curSticky.find('.wps-modify, .wps-controls').addClass('wps-hidden');
		}
	};

	// Showing or hiding content

	var wpsSetContent = function( el, curSticky ){

		var wps = el.data('wpStickies');

		curSticky.find('.wps-logo').removeClass('wps-logo-active');
		curSticky.find('.wps-urleditable').removeClass('wps-urleditable-active');

		var elSpotTitle = curSticky.find('.wps-spottitle');
		var elSpotContent = curSticky.find('.wps-spotcontent');
		var elSpotURL = curSticky.find('.wps-spoturl');
		var elGoogle = curSticky.find('.wps-google');
		var elYouTube = curSticky.find('.wps-youtube');
		var elVimeo = curSticky.find('.wps-vimeo');
		var elWikipedia = curSticky.find('.wps-wikipedia');
		var elFacebook = curSticky.find('.wps-facebook');
		var elLogos = curSticky.find('.wps-logos');

		if( elSpotTitle.html() != '' ){
			elSpotTitle.removeClass('wps-hidden');
		}else{
			elSpotTitle.addClass('wps-hidden');
		}

		if( elSpotContent.html() != '' ){
			elSpotContent.removeClass('wps-hidden');
		}else{
			elSpotContent.addClass('wps-hidden');
		}

		if( elSpotURL.attr('href') != '' ){
			elSpotURL.removeClass('wps-hidden');
		}else{
			elSpotURL.addClass('wps-hidden');
		}

		elSpotURL.attr('target', curSticky.data('stickyData').spot.urlSpotTarget);

		if( elGoogle.attr('href') != '' ){
			elGoogle.removeClass('wps-hidden');
		}else{
			elGoogle.addClass('wps-hidden');
		}

		if( elYouTube.attr('href') != '' ){
			elYouTube.removeClass('wps-hidden');
		}else{
			elYouTube.addClass('wps-hidden');
		}

		if( elVimeo.attr('href') != '' ){
			elVimeo.removeClass('wps-hidden');
		}else{
			elVimeo.addClass('wps-hidden');
		}

		if( elWikipedia.attr('href') != '' ){
			elWikipedia.removeClass('wps-hidden');
		}else{
			elWikipedia.addClass('wps-hidden');
		}

		if( elFacebook.attr('href') != '' ){
			elFacebook.removeClass('wps-hidden');
		}else{
			elFacebook.addClass('wps-hidden');
		}

		if( elGoogle.hasClass('wps-hidden') && elYouTube.hasClass('wps-hidden') && elVimeo.hasClass('wps-hidden') && elWikipedia.hasClass('wps-hidden') && elFacebook.hasClass('wps-hidden') && !curSticky.hasClass('wps-creating') ){
			elLogos.addClass('wps-hidden');
		}else{
			elLogos.removeClass('wps-hidden');
		}

		if( elGoogle.hasClass('wps-hidden') && elYouTube.hasClass('wps-hidden') && elVimeo.hasClass('wps-hidden') && elWikipedia.hasClass('wps-hidden') && elFacebook.hasClass('wps-hidden') && elSpotTitle.hasClass('wps-hidden') && elSpotContent.hasClass('wps-hidden') && !curSticky.hasClass('wps-editable') ){
			curSticky.find('.wps-spotbubble').addClass('wps-hidden');
		}
	};

	var wpsDisableSelection = function( el ){

		el.addClass('wps-unselectable');

		el.onselectstart = function(){
			return false;
		};
	};

	var wpsShowMessage = function( el, message, duration ){

		var wps = el.data('wpStickies');

		if( wps.o.settings.showMessages && !wps.g.disableStickies ){

			if( wps.g.msgTimer ){
				clearTimeout( wps.g.msgTimer );
				wps.g.messagebox.stop().css({
					display: 'none'
				});
			}
			wps.g.message.html( message );
			wps.g.messagebox.stop().slideDown( 250, 'easeInOutQuad' );
			wps.g.msgTimer = setTimeout( function(){ wpsHideMessage( el ) }, duration );
		}
	};

	var wpsAddRemove = function( el, curSticky ){

		var wps = el.data('wpStickies');

		var stickyRemove = $('<a href="#" class="wps-remove"></a>');

		if( curSticky.hasClass('wps-spot') ){
			stickyRemove.appendTo( curSticky.find('.wps-spotbubble') );
		}else{
			stickyRemove.appendTo( curSticky );
		}

		stickyRemove.click(function(e){
			e.preventDefault();
			e.stopPropagation();
			if( curSticky.hasClass('wps-saved') ){
				var confRemove = confirm( wps.o.language.confRemove );
				if( confRemove ){
					wpsRemoveSticky( el, curSticky );
				}
			}else{
				wpsRemoveSticky( el, curSticky );
			}
		});
	};

	var wpsHideMessage = function( el ){

		var wps = el.data('wpStickies');

		wps.g.messagebox.stop().slideUp( 250, 'easeInOutQuad' );
	};

})(jQuery);
